using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    class GTOpPincodeCall : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        //public SIPPBXChan _chan1;
        public GTOpAudioPlay _op_ap;

        public GTOpPincodeCall(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _op_ap = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpPincodeCall::start()########################====>>");


            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dial_tone);
            _op_ap = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000);
            _op_ap.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_ap)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    string digits = _op_ap.getDTMFStr();
                    string logInfo;

                    if (digits.Length <= 1)
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(_pbx.pbx_dial_tone);
                        _op_ap = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000);
                        _op_ap.perform();
                    }
                    else
                    {
                        SIPPBXDialPlan dp = _pbx.getDialPlanByCalledNum(_env, digits, "", _chan.link_exten.UserName, "", _chan.link_exten, 1);
                        if (dp != null)
                        {
                            _env.LogoutText("Call to " + digits + " using dialplan " + dp.planName);

                            if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                            {
                                _chan.call_dir = 1;

                                if (_env.GetChanCallCredit(_chan.index) > 0 || _chan.link_exten.AuthType == 2)
                                {
                                    if (_chan.link_exten.bOnlyAgentLogin && _chan.link_exten.Agent == null)
                                    {
                                        logInfo = "Extension " + _chan.link_exten.UserName + " must have an agent to login in order to call out!";
                                        _env.LogoutText(logInfo);
                                        _env.DisconnectCall(_chan.index, 480, "Temporarily Unavailable", "PBX: " + logInfo);
                                        return;
                                    }
                                    GTOpOutbound op_out = new GTOpOutbound(_pbx, _env, _chan, dp);
                                    op_out._called_id = digits;
                                    _chan.async_op_compound = op_out;
                                    _chan.async_op_compound.start();
                                }
                                else
                                {
                                    logInfo = "Call(from " + _chan.link_exten.UserName + " to " + digits + ") is rejected because caller didn't pass authentication!";
                                    _env.LogoutText(logInfo);
                                    _env.DisconnectCall(_chan.index, 406, "Not Acceptable", "PBX: " + logInfo);
                                    return;
                                }
                            }
                            else
                            {
                                List<string> audio_files = new List<string>();
                                audio_files.Add(_pbx.pbx_dial_tone);
                                _op_ap = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000);
                                _op_ap.perform();
                            }
                            
                        }
                        else
                        {
                            List<string> audio_files = new List<string>();
                            audio_files.Add(_pbx.pbx_dial_tone);
                            _op_ap = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000);
                            _op_ap.perform();
                        }
                    }
                }
                else
                {
                    List<string> audio_files = new List<string>();
                    audio_files.Add(_pbx.pbx_dial_tone);
                    _op_ap = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000);
                    _op_ap.perform();
                }
            }
        }
    }
}
