using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpOutbound : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXDialPlan  _dp;
        public SIPPBXChan _chan;
        public GTOpCallTransfer _op_call_transfer;
        public GTOpAnswerCall _op_answer_call;
        public SIPPBXExten _exten;

        public bool _check_caller_extn;

        public string _caller_id;
        public string _called_id;

        //public GTOpVMB _op_vmb;

        public CallJob _call_job;

        public CallLimit _cl;

        public GTOpOutbound(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXDialPlan dp):base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _dp = dp;
            _op_call_transfer = null;
            //_op_vmb = null;
            _exten = null;

            _check_caller_extn = true;

            _caller_id = "";
            _called_id = "";

            _call_job = null;

            _cl = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpOutbound::start()########################====>>");

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            string caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");
            string callee_num = api_chan.callee_num;
            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
            string toid_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, callee_num);

            if (_called_id.Length > 0)
                toid_username = _called_id;

            if (_caller_id.Length > 0)
                caller_username = _caller_id;

            SIPPBXExten extn = null;

            if (_dp != null)
            {
                _env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 1!");

                if (_dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                {
                    _env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 2!");
                    if (_check_caller_extn)
                    {
                        extn = _pbx.getExtensionBySIPAddr(caller_num);
                        if (extn == null && _dp.MemberList != null)
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because caller is not an extension!");
                            _env.LOG_Trace(4, "Call is rejected because caller is not an extension!");
                            _env.LogoutText("Call is rejected because caller is not an extension!");
                            return;
                        }
                    }

                    //check call limit and call block
                    _cl = _pbx.getCallLimit(_dp, caller_username, toid_username, _chan);
                    if (_cl != null)
                    {
                        if (_cl.Seconds <= 0)
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no enough minute left!");
                            _env.LOG_Trace(4, "Call is rejected because there is no enough minute left!");
                            _env.LogoutText("Call is rejected bbecause there is no enough minute left!");
                            return;
                        }
                    }


                    if (!_pbx.passCallBlackList(_env, _dp, caller_username, toid_username))
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because it is in blacklist!");
                        _env.LOG_Trace(4, "Call is rejected because it is in blacklist!");
                        _env.LogoutText("Call is rejected bbecause it is in blacklist!");
                        return;
                    }
                    

                    //this may not be useful any more as the outbound plan
                    //can set each extension individually
                    if (_dp.ExtenPriorityLevel != 0)
                    {
                        if ((_dp.ExtenPriorityLevel & extn.PriorityLevel) == 0)
                        {
                            //not authorized to make this call
                            //disconnect call
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: not authorized to make this call");
                            return;
                        }
                    }

                    SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(_dp);
                    if (sip_acct != null)
                    {
                        _env.LOG_Trace(4, "GTOpOutbound::start()#### Calling out using sip_account: " + sip_acct.DisplayName + " " + sip_acct.UserName + " " + _dp.OutboundPrepend + " " + _dp.OutboundPreStrip);

                        //outbound, should take out predix digit, then use another channel to dialout
                        string destaddr = _dp.OutboundPrepend + toid_username.Substring(_dp.OutboundPreStrip.Length);
                        destaddr += "@" + sip_acct.DomainServer;
                        destaddr = "<sip:" + destaddr + ">";

                        string fromaddr = sip_acct.UserName;
                        if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                        {
                            SIPPBXExten ext0 = _pbx.getExtensionByName(caller_username);
                            if (ext0 != null)
                            {
                                if (ext0.AlternativePhoneNumber.Length > 0)
                                {
                                    fromaddr = ext0.AlternativePhoneNumber;
                                }
                                else if (sip_acct.DIDList.Count > 0)
                                {
                                    fromaddr = sip_acct.DIDList[0];
                                    if (sip_acct.OutboundAppendExtenID)
                                    {
                                        fromaddr += ext0.UserName;
                                    }
                                }
                            }
                            else
                            {
                                fromaddr = caller_username;
                                if (fromaddr == "unknown")
                                    fromaddr = sip_acct.UserName;
                            }
                        }

                        if (fromaddr == "")
                        {
                            if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                fromaddr = caller_username; 
                            else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                fromaddr = sip_acct.DIDList[0];
                            else if (sip_acct.UserName.Length > 0)
                                fromaddr = sip_acct.UserName;
                            else
                                fromaddr = "unknown";
                        }

                        if (sip_acct.UseLocalIPInFrom)
                        {
                            if (_pbx.sip_set.sipAddr.Length > 0)
                                fromaddr += "@" + _pbx.sip_set.sipAddr;
                            else
                                fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                        }
                        else
                            fromaddr += "@" + sip_acct.DomainServer;
                        fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                        if (!transferCall(destaddr, fromaddr, null, sip_acct))
                        {
                            //no enough idle channel for outbound
                            //just disconnect now
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                            _env.LOG_Trace(4, "Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                            _env.LogoutText("Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                        }
                    }
                    else
                    {
                        //cannot find right SIP account for outbound
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because it cannot find right SIP account for outbound!");
                        _env.LOG_Trace(4, "Call is rejected because it cannot find right SIP account for outbound!");
                        _env.LogoutText("Call is rejected because it cannot find right SIP account for outbound!");
                    }
                }
                else
                {
                    //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 3!");

                    if (_dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                    {
                        //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 4!");

                        extn = _pbx.getExtensionByName(_dp.DestAddress);

                        if (extn != null)
                        {
                            //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 5!");

                            if (extn.IsVirtualExten())
                            {
                                //calling to a virtual extension
                                if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                                {
                                    //sip address
                                    string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", toid_username);

                                    if (sipDestAddr.Contains("@"))
                                    {
                                        string dpname = sipDestAddr.Substring(sipDestAddr.IndexOf('@') + 1);
                                        SIPPBXDialPlan dp1 = _pbx.getDialPlanByPlanName(dpname);
                                        if (dp1 != null)
                                        {
                                            if (dp1.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                                            {
                                                SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
                                                if (sip_acct != null)
                                                {
                                                    //outbound, should take out predix digit, then use another channel to dialout
                                                    string destaddr = dp1.OutboundPrepend + sipDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                                    //if (extn.bAcceptOtherID && toid_username.Length > 0) destaddr = toid_username;
                                                    destaddr += "@" + sip_acct.DomainServer;
                                                    destaddr = "<sip:" + destaddr + ">";

                                                    string fromaddr = sip_acct.UserName;
                                                    if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                                                    {
                                                        SIPPBXExten ext0 = _pbx.getExtensionByName(caller_username);
                                                        if (ext0 != null)
                                                        {
                                                            if (ext0.AlternativePhoneNumber.Length > 0)
                                                            {
                                                                fromaddr = ext0.AlternativePhoneNumber;
                                                            }
                                                            else if (sip_acct.DIDList.Count > 0)
                                                            {
                                                                fromaddr = sip_acct.DIDList[0];
                                                                if (sip_acct.OutboundAppendExtenID)
                                                                {
                                                                    fromaddr += ext0.UserName;
                                                                }
                                                            }
                                                        }
                                                        else
                                                        {
                                                            fromaddr = caller_username;
                                                            if (fromaddr == "unknown")
                                                                fromaddr = sip_acct.UserName;
                                                        }
                                                    }

                                                    if (fromaddr == "")
                                                    {
                                                        if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                                            fromaddr = caller_username;
                                                        else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                                            fromaddr = sip_acct.DIDList[0];
                                                        else if (sip_acct.UserName.Length > 0)
                                                            fromaddr = sip_acct.UserName;
                                                        else
                                                            fromaddr = "unknown";
                                                    }

                                                    if (sip_acct.UseLocalIPInFrom)
                                                    {
                                                        if (_pbx.sip_set.sipAddr.Length > 0)
                                                            fromaddr += "@" + _pbx.sip_set.sipAddr;
                                                        else
                                                            fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                                                    }
                                                    else
                                                        fromaddr += "@" + sip_acct.DomainServer;
                                                    fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                                                    if (!transferCall(destaddr, fromaddr, extn, sip_acct))
                                                    {
                                                        //no enough idle channel for outbound
                                                        //just disconnect now
                                                        _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                                        _env.LOG_Trace(4, "Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                                        _env.LogoutText("Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                                    }
                                                }
                                                else
                                                {
                                                    //cannot find right SIP account for outbound
                                                    _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because it cannot find right SIP account for outbound!");
                                                    _env.LOG_Trace(4, "Call is rejected because it cannot find right SIP account for outbound!");
                                                    _env.LogoutText("Call is rejected because it cannot find right SIP account for outbound!");
                                                }

                                                return;
                                            }
                                        }
                                    }

                                    if (sipDestAddr.Contains("sip:"))
                                    {
                                        if (!transferCall(sipDestAddr, caller_num, extn, null))
                                        {
                                            //no enough idle channel for outbound
                                            //just disconnect now
                                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                            _env.LOG_Trace(4, "Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                            _env.LogoutText("Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                        }
                                    }
                                    else
                                    {
                                        if (!transferCall("<sip:" + sipDestAddr + ">", caller_num, extn, null))
                                        {
                                            //no enough idle channel for outbound
                                            //just disconnect now
                                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                            _env.LOG_Trace(4, "Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                            _env.LogoutText("Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                        }
                                    }
                                }
                                else
                                {
                                    string sipDestAddr = extn.VirtualExtenDestAddr;
                                    if(extn.VirtualExtenDestAddr.Contains("*"))
                                        sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", toid_username);

                                    //to see if it matchs any outbound rules
                                    SIPPBXDialPlan dp1 = _pbx.getDialPlanByCalledNum(_env, sipDestAddr, "", caller_username, "", _pbx.getExtensionBySIPAddr(caller_num), 1);
                                    if (dp1 != null)
                                    {
                                        SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
                                        if (sip_acct != null)
                                        {
                                            //outbound, should take out predix digit, then use another channel to dialout
                                            string destaddr = dp1.OutboundPrepend + sipDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                            //if (extn.bAcceptOtherID && toid_username.Length > 0) destaddr = toid_username;
                                            destaddr += "@" + sip_acct.DomainServer;
                                            destaddr = "<sip:" + destaddr + ">";

                                            string fromaddr = sip_acct.UserName;
                                            if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                                            {
                                                SIPPBXExten ext0 = _pbx.getExtensionByName(caller_username);
                                                if (ext0 != null)
                                                {
                                                    if (ext0.AlternativePhoneNumber.Length > 0)
                                                    {
                                                        fromaddr = ext0.AlternativePhoneNumber;
                                                    }
                                                    else if (sip_acct.DIDList.Count > 0)
                                                    {
                                                        fromaddr = sip_acct.DIDList[0];
                                                        if (sip_acct.OutboundAppendExtenID)
                                                        {
                                                            fromaddr += ext0.UserName;
                                                        }
                                                    }
                                                }
                                                else
                                                {
                                                    fromaddr = caller_username;
                                                    if (fromaddr == "unknown")
                                                        fromaddr = sip_acct.UserName;
                                                }
                                            }

                                            if (fromaddr == "")
                                            {
                                                if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                                    fromaddr = caller_username;
                                                else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                                    fromaddr = sip_acct.DIDList[0];
                                                else if (sip_acct.UserName.Length > 0)
                                                    fromaddr = sip_acct.UserName;
                                                else
                                                    fromaddr = "unknown";
                                            }

                                            if (sip_acct.UseLocalIPInFrom)
                                            {
                                                if (_pbx.sip_set.sipAddr.Length > 0)
                                                    fromaddr += "@" + _pbx.sip_set.sipAddr;
                                                else
                                                    fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                                            }
                                            else
                                                fromaddr += "@" + sip_acct.DomainServer;
                                            fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                                            if (!transferCall(destaddr, fromaddr, extn, sip_acct))
                                            {
                                                //no enough idle channel for outbound
                                                //just disconnect now
                                                _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                                _env.LOG_Trace(4, "Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                                _env.LogoutText("Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                            }
                                        }
                                        else
                                        {
                                            //cannot find right SIP account for outbound
                                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because it cannot find right SIP account for outbound!");
                                            _env.LOG_Trace(4, "Call is rejected because it cannot find right SIP account for outbound!");
                                            _env.LogoutText("Call is rejected because it cannot find right SIP account for outbound!");
                                        }
                                    }
                                    else
                                    {
                                        _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no outbound dialplan matched!");
                                        _env.LOG_Trace(4, "Call is rejected because there is no outbound dialplan matched!");
                                        _env.LogoutText("Call is rejected because there is no outbound dialplan matched!");
                                    }
                                }
                            }
                            else
                            {
                                //regular extension
                                if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                                {
                                    //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 6!");

                                    string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, _chan);

                                    if (!transferCall(sCallee, caller_num, extn, null))
                                    {
                                        //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 7!");

                                        //no enough idle channel for outbound
                                        //just disconnect now
                                        _env.DisconnectCall(_chan.index, 0, "", "PBX: Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                        _env.LOG_Trace(4, "Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                        _env.LogoutText("Call is rejected because there is no idle channel! You need to upgrade your PBX for more channels.");
                                    }
                                }
                                else
                                {
                                    /*
                                    _env.Send_HungUp(_chan.index);
                                    _env.LOG_Trace(4, "Call is rejected because the called extension is not registered to the PBX.");
                                    _env.LogoutText("Call is rejected because the called extension is not registered to the PBX.");
                                     */
                                    _exten = extn;
                                    toVMB(extn);
                                    //_env.LOG_Trace(4, "Start perform asyncronized compound - GTOpOutbound 8!");
                                }
                            }
                        }
                    }
                }
            }
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_call_transfer)
            {
                GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);

                if (_op_call_transfer.trans_succeed)
                {
                    if (_env.IsChanConnected(_chan.index) && _pbx.IsPBXChanInParkingSlot(_chan) == null)
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: transfer call done in Outbound");
					
					if(_cl != null)
					{
						GTAPIASM.GTAPIChan api_chan1 = _env.GetChannel(_op_call_transfer.trans_chan.index);
                        TimeSpan tsp = DateTime.Now - api_chan1.call_start_time;
						_pbx.countCallLimit(_env, _cl, tsp);
					}					
                }
                else
                {
                    _exten = _op_call_transfer.trans_chan.link_exten;

                    if (_exten != null)
                    {
                        if (_env.IsChanConnected(_chan.index) || api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED)
                        {
                            toVMB(_exten);
                        }
                        else if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                        {
                            _env.DisconnectCall(_chan.index, _op_call_transfer.disc_code, _op_call_transfer.disc_desc, "PBX: transfer failed in Outbound");
                        }
                    }
                    else
                    {
                        //outbound call to outside phone number.
                        //Erkan asked to play a busy tone sound before disconnecting when the channel is already connected
                        _env.DisconnectCall(_chan.index, _op_call_transfer.disc_code, _op_call_transfer.disc_desc, "PBX: transfer failed in Outbound");
                    }
                }
            }
            else if (opAsync == _op_answer_call)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_exten != null)
                    {
                        SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, _exten);
                    }
                    else
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: answered call, but _exten is null in Outbound");
                    }
                }
                else
                {
                    //call cannot be answered. must be idle already.
                }
            }

        }


        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            SIPPBXChan chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (chan2 == null)
            {
                _env.LogoutText("GTOpOutbound::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            chan2.link_exten = extn;
            if(extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered
            if (_call_job != null)
                chan2.call_job = _call_job;
            _op_call_transfer = new GTOpCallTransfer(this, _env, _chan, _chan.DTMFBuf, chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer._cl = _cl;
            _op_call_transfer.perform();

            return true;
        }

        public void toVMB(SIPPBXExten extn)
        {
            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            if (api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED)
            {
                _op_answer_call = new GTOpAnswerCall(this, _env, _chan);
                _op_answer_call.perform();
            }
            else if (api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED)
            {
                SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, extn);
            }
        }

    }
}
