using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpIVRMenu : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXIVR _ivr;
        public SIPPBXChan _chan;
        public SIPPBXExten _exten;
        public GTOpAudioPlay _op_audio_play;
        public GTOpDTMFDetect _op_dtmf_detect;
        public GTOpCallTransfer _op_call_transfer;

        public GTOpIVRMenu(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXIVR ivr):base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _ivr = ivr;
            _exten = null;
            _op_audio_play = null;
            _op_dtmf_detect = null;
            _op_call_transfer = null;
        }

        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            SIPPBXChan chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (chan2 == null)
            {
                //not enough outbound channel available
                //just disconnect it
                _env.LogoutText("GTOpIVRMenu::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling! Disconnecting ......");
                _env.DisconnectCall(_chan.index, 0, "", "PBX: GTOpIVRMenu::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling! Disconnecting ......");
                return false;
            }

            _op_audio_play = null;
            _op_dtmf_detect = null;
            _op_call_transfer = null;

            chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            chan2.link_exten = extn;
            _exten = extn;
            if(extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered

            _op_call_transfer = new GTOpCallTransfer(this, _env, _chan, _chan.DTMFBuf, chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer.perform();
            return true;
        }

        public bool TryReachVoiceMailBox(string vmb_name)
        {
            SIPPBXExten extn = _pbx.getExtensionByName(vmb_name);
            if (extn != null)
            {
                if (extn.vmb != null)
                {
                    _chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, extn.vmb);
                    _chan.async_op_compound.start();
                    return true;
                }
            }

            return false;
        }

        public bool TryReachACD(string acd_name)
        {
            SIPPBXACDHuntGroup hg = _pbx.getACDByName(acd_name);
            if (hg != null)
            {
                if (hg.calls.Count >= hg.maxNumOfCalls && hg.maxNumOfCalls > 0)
                {
                    //ACD queue full
                    if (hg.callForwardingType == 0) //to another ACD group
                    {
                        SIPPBXACDHuntGroup hg1 = _pbx.getACDByName(hg.callForwardingPlan);
                        if (hg1 != null)
                        {
                            _chan.async_op_compound = new GTOpACD(_pbx, _env, _chan, hg1, _pbx.moh_dir, false);
                            _chan.async_op_compound.start();
                            return true;
                        }
                        else
                        {
                            _env.LogoutText("Cannot find huntgroup(" + hg.callForwardingPlan + ") for incoming calls.");
                            return false;
                        }
                    }
                    else if (hg.callForwardingType == 1) //to another Dialplan
                    {
                        SIPPBXDialPlan dp_hg = _pbx.getDialPlanByPlanName(hg.callForwardingPlan);
                        if (dp_hg != null)
                        {
                            _chan.dp = dp_hg;
                            _env.DoDialPlan(_chan.index, _chan, null, null);
                            return true;
                        }
                        else
                        {
                            _env.LogoutText("Cannot find dialplan(" + hg.callForwardingPlan + ") for incoming calls.");
                            return false;
                        }
                    }
                    else
                    {
                        _env.LogoutText("ACD group " + hg.hgName + " queue is full, but forwarding type is not correct!");
                        return false;
                    }
                }
                else
                {
                    _chan.async_op_compound = new GTOpACD(_pbx, _env, _chan, hg, _pbx.moh_dir, false);
                    _chan.async_op_compound.start();
                    return true;
                }
            }
            else
            {
                _env.LogoutText("Cannot find huntgroup(" + acd_name + ") for incoming calls.");
                return false;
            }

        }

        public bool TryReachMonitorGroup(string mg_name)
        {
            SIPPBXMonitorGroup mg = _pbx.getMonitorGroupByNumber(mg_name);
            if (mg != null)
            {
                _chan.async_op_compound = new GTOpMonitorGroup(_pbx, _env, _chan, mg, _chan.link_exten);
                _chan.async_op_compound.start();
                return true;
            }
            else
            {
                _env.LogoutText("Cannot find monitor group(" + mg_name + ") for incoming calls.");
                return false;
            }           
        }

        public bool TryReachRingGroup(string rg_name)
        {
            SIPPBXRingGroup rg = _pbx.getRingGroupByName(rg_name);
            if (rg != null)
            {
                _chan.async_op_compound = new GTOpRingGroup(_pbx, _env, _chan, rg, _pbx.moh_dir);
                _chan.async_op_compound.start();
                return true;
            }
            else
            {
                _env.LogoutText("Cannot find ringgroup(" + rg_name + ") for incoming calls.");
                return false;
            }

        }

        public void TryReachVoiceMailBox(VoiceMailBox vmb)
        {
            _chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, vmb);
            _chan.async_op_compound.start();
        }

        public bool TryRunPlugin(string plugin_name)
        {
            if (_pbx.bFreeVersion || _pbx.PBXLicKey.Length < 29)
            {
                if (_chan.index > 0)
                {
                    _env.LogoutText("Free Version only allows pbx to run plugin on the first channel!");
                    return false;
                }
            }
            else
            {
                if (_env.GetLicTo().Length == 0)
                {
                    //non-free-version, but without right licence key
                    if (_chan.index > 0)
                    {
                        _env.LogoutText("Trail Version only allows pbx to run plugin on the first channel!");
                        return false;
                    }
                }
            }

            ISIPPBXPluginClient client = _pbx.GetPluginClientInterfaceByName(plugin_name);
            if (client == null)
            {
                _env.LogoutText("Plugin(" + plugin_name + ") doesn't exist!");
                return false;
            }

            if (client.Type != "IVRMenu")
            {
                _env.LogoutText("Plugin(" + plugin_name + ") is not IVRMenu Type!");
                return false;
            }

            SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
            _chan.plugin_host = plugin_host;
            plugin_host.pbx_chan = _chan;
            plugin_host.env = _env;
            if (plugin_host.Register(client))
            {
                _chan.async_op_compound = new GTOpPluginCompound(_pbx, _env, _chan);
                plugin_host.event_wait_handle.Set();
            }

            return true;
        }

        public bool TryReachExtension(string exten_name)
        {
            SIPPBXExten extn = _pbx.getExtensionByName(exten_name);
            if (extn == null)
                return false;

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            string caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");
            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
            string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num); 

            if (extn.IsVirtualExten())
            {
                //calling to a virtual extension
                if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                {
                    //sip address
                    string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                    if (sipDestAddr.Contains("sip:"))
                    {
                        if (!transferCall(sipDestAddr, caller_num, extn, null))
                        {
                            //no enough idle channel for outbound
                            if (extn.vmb != null)
                                TryReachVoiceMailBox(extn.vmb);
                            else
                                _env.DisconnectCall(_chan.index, 0, "", "PBX: TryReachExtension in IVRMenu. No VMB.");
                        }
                    }
                    else
                    {
                        if (!transferCall("<sip:" + sipDestAddr + ">", caller_num, extn, null))
                        {
                            //no enough idle channel for outbound
                            if (extn.vmb != null)
                                TryReachVoiceMailBox(extn.vmb);
                            else
                                _env.DisconnectCall(_chan.index, 0, "", "PBX: TryReachExtension in IVRMenu. No VMB 1.");
                        }
                    }
                }
                else
                {
                    //to see if it matchs any outbound rules
                    SIPPBXDialPlan dp1 = _pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, caller_num), _pbx.getExtensionBySIPAddr(caller_num), 1);
                    if (dp1 != null)
                    {
                        SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
                        if (sip_acct != null)
                        {
                            //outbound, should take out predix digit, then use another channel to dialout
                            string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                            if (extn.bAcceptOtherID && called_num.Length > 0)
                                destaddr = called_num;
                            destaddr += "@" + sip_acct.DomainServer;
                            destaddr = "<sip:" + destaddr + ">";

                            string fromaddr = sip_acct.UserName;
                            if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                            {
                                SIPPBXExten ext0 = _pbx.getExtensionBySIPAddr(caller_num);
                                if (ext0 != null)
                                {
                                    if (ext0.AlternativePhoneNumber.Length > 0)
                                    {
                                        fromaddr = ext0.AlternativePhoneNumber;
                                    }
                                    else if (sip_acct.DIDList.Count > 0)
                                    {
                                        fromaddr = sip_acct.DIDList[0];
                                        if (sip_acct.OutboundAppendExtenID)
                                        {
                                            fromaddr += ext0.UserName;
                                        }
                                    }
                                }
                                else
                                {
                                    fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                                    if (fromaddr == "unknown")
                                        fromaddr = sip_acct.UserName;
                                }
                            }

                            if (fromaddr == "")
                            {
                                if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                    fromaddr = caller_username;
                                else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                    fromaddr = sip_acct.DIDList[0];
                                else if (sip_acct.UserName.Length > 0)
                                    fromaddr = sip_acct.UserName;
                                else
                                    fromaddr = "unknown";
                            }

                            if (sip_acct.UseLocalIPInFrom)
                            {
                                if (_pbx.sip_set.sipAddr.Length > 0)
                                    fromaddr += "@" + _pbx.sip_set.sipAddr;
                                else
                                    fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                            }
                            else
                                fromaddr += "@" + sip_acct.DomainServer;
                            fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                            if (!transferCall(destaddr, fromaddr, extn, sip_acct))
                            {
                                //no enough idle channel for outbound
                                if (extn.vmb != null)
                                    TryReachVoiceMailBox(extn.vmb);
                                else
                                    return false;
                            }
                        }
                        else
                        {
                            //cannot find right SIP account for outbound
                            if (extn.vmb != null)
                                TryReachVoiceMailBox(extn.vmb);
                            else
                                return false;
                        }
                    }
                    else
                    {
                        if (extn.vmb != null)
                            TryReachVoiceMailBox(extn.vmb);
                        else
                            return false;
                    }
                }
            }
            else
            {
                //regular extension
                if (extn.IsRegistered())
                {
                    string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, _chan);

                    if (!transferCall(sCallee, caller_num, extn, null))
                    {
                        //no enough idle channel for outbound
                        if (extn.vmb != null)
                            TryReachVoiceMailBox(extn.vmb);
                        else
                            return false;
                    }
                }
                else
                {
                    if (extn.vmb != null)
                        TryReachVoiceMailBox(extn.vmb);
                    else
                        return false;
                }
            }

/*
            string sCaller;
            string sCallee;
            if (extn.IsVirtualExten()) //virtual extension
            {
                sCaller = "";
                sCallee = extn.VirtualExtenDestAddr;
            }
            else
            {
                sCaller = "<sip:" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, _env.GetChannel(_chan.index).caller_num);
                sCaller += "@";
                sCaller += GTAPIASM.GTAPIEnv.GetLocalIP(0);
                sCaller += ">";
                sCallee = extn.ContactAddr;
            }

            if (!transferCall(sCallee, sCaller, extn))
            {
                //no enough channel for transfering
                //direct call to voice mail box route
                //not available here
            }
*/

            return true;
        }

        public bool MatchIVRMenu(string dtmfStr)
        {
            //choose a valid menu or extension.
            if (_ivr.dtmf_accept_exten)
            {
                if (TryReachExtension(dtmfStr))
                {
                    if (_chan.call_job != null && _ivr.name.Length > 0)
                    {
                        _chan.call_job.DTMFs += _ivr.name + "," + dtmfStr + ";";
                    }
                    return true;
                }
            }

            for (int i = 0; i < _ivr.dtmfs.Count; i++)
            {
                if (dtmfStr == "" && _ivr.dtmfs[i].DTMFStr == "No Input")
                {
                    if (_chan.call_job != null && _ivr.name.Length > 0)
                    {
                        _chan.call_job.DTMFs += _ivr.name + "," + dtmfStr + ";";
                    }
                    _ivr = _ivr.dtmfs[i].IVRMenu;
                    start();
                    return true;
                }
                if (dtmfStr == _ivr.dtmfs[i].DTMFStr)
                {
                    if (_chan.call_job != null && _ivr.name.Length > 0)
                    {
                        _chan.call_job.DTMFs += _ivr.name + "," + dtmfStr + ";";
                    }
                    _ivr = _ivr.dtmfs[i].IVRMenu;
                    start();
                    return true;
                }
            }

            return false;
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            List<string> dtmf_opts = getDTMFOptions();
            int max_digits = 0;
            for (int i = 0; i < dtmf_opts.Count; i++)
            {
                if (dtmf_opts[i].Length > max_digits)
                    max_digits = dtmf_opts[i].Length;
            }

            if (opAsync == _op_audio_play)
            {
                //should consider if the result is aborted.
                //in one case, once the channel is disconnected when playing, it will go next to ring extension
                //so here just check if the channel status is still connected
                //result == GTOpAsync.ResultCode.OP_RESULT_ABORTED?
                if (_env.IsChanConnected(_chan.index))
                {
                    if (_ivr.action == 0) //nothing, no defined yet
                    {
                    }
                    else if (_ivr.action == 1) ////play sound and detect dtmf
                    {
                        if (_op_audio_play.isDTMFMatched())
                        {
                            _chan.ivrKeys += _ivr.name + ":" + _op_audio_play.getDTMFStr() + ";";

                            if (!MatchIVRMenu(_op_audio_play.getDTMFStr().TrimEnd('#')))
                            {
                                //???
                                //Should never reach here
                                //just start the menu again
                                start();
                            }
                        }
                        else
                        {
                            _chan.ivrKeys += _ivr.name + ":" + _op_audio_play.getDTMFStr() + ";";
                            _chan.DTMFBuf = _op_audio_play.getDTMFStr().TrimEnd('#');

                            if (_chan.DTMFBuf.Length >= 4)
                            {
                                start();
                            }
                            else
                            {
                                _op_dtmf_detect = new GTOpDTMFDetect(this, _env, _chan, _chan.DTMFBuf, dtmf_opts, (max_digits - _chan.DTMFBuf.Length), "#", _ivr.menu_dtmf_wait_ms);
                                _op_dtmf_detect.timeout1 = _ivr.dtmf_accept_exten_wait_ms;
                                _op_dtmf_detect.perform();
                            }

                        }
                    }
                    else if (_ivr.action == 2) //play sound and dial extension
                    {
                        if (!TryReachExtension(_ivr.transfer_to))
                        {
                            //extension is not right, hungup here
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: extension is not right, hungup here in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 3) //play sound and goto another menu
                    {
                        //_ivr = _ivr.ParentIVRMenu;
                        SIPPBXIVR ivrmenu = _pbx.getIVRMenuByName(_ivr.transfer_to);
                        if (ivrmenu != null)
                        {
                            _ivr = ivrmenu;
                            start();
                        }
                        else
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: IVRMenu " + _ivr.transfer_to + " cannot be found in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 4) //play sound(if available) and go hunt group
                    {
                        if (!TryReachACD(_ivr.transfer_to))
                        {
                            //extension is not right, hungup here
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: cannot reach ACD in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 5) //play sound(if available) and forward call to
                    {
                    }
                    else if (_ivr.action == 6) //play sound(if available) and go to "Monitor" group
                    {
                        if (!TryReachMonitorGroup(_ivr.transfer_to))
                        {
                            //extension is not right, hungup here
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: cannot reach MonitorGroup in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 7) //play sound(if available) and go to "Ring group"
                    {
                        if (!TryReachRingGroup(_ivr.transfer_to))
                        {
                            //extension is not right, hungup here
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: cannot reach RingGroup in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 8) //play sound(if available) and go to "Conference room"
                    {
                        _pbx.SetChanIntoConferenceRoom(_env, _chan, _ivr.transfer_to, 1);
                    }
                    else if (_ivr.action == 9) //play sound(if available) and go to "Voice mail box"
                    {
                        if (!TryReachVoiceMailBox(_ivr.transfer_to))
                        {
                            //cannot reach this extension's voice mail box,
                            //nothing else can do, just hungup
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: cannot reach VoiceMailBox in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 10) //play sound(if available) and hung up
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: play sound(if available) and hung up");
                    }
                    else if (_ivr.action == 11) //play sound(if available) and run plugin
                    {
                        if (!TryRunPlugin(_ivr.transfer_to))
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: TryRunPlugin failed in IVRMenu");
                        }
                    }
                    else if (_ivr.action == 12) //play sound and goto another dialplan
                    {
                        SIPPBXDialPlan dp = _pbx.getDialPlanByPlanName(_ivr.transfer_to);
                        if (dp != null)
                        {
                            _env.DoDialPlan(_chan.index, _chan, null, null);
                        }
                        else
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: Dialplan " + _ivr.transfer_to + " cannot be found in IVRMenu");
                        }
                    }
                }
            }
            else if (opAsync == _op_dtmf_detect)
            {
                if (_env.IsChanConnected(_chan.index))
                {
                    _chan.ivrKeys += _ivr.name + ":" + _op_dtmf_detect.getDTMFStr() + ";";
                    if (_ivr.action == 0) //nothing, no defined yet
                    {
                        //impossible here
                    }
                    else if (_ivr.action == 1) ////play sound and detect dtmf
                    {
                        if (!MatchIVRMenu(_op_dtmf_detect.getDTMFStr()))
                        {
                            //if there is no right choice for ivr menu
                            //we just restart ivr menu again
                            start();
                        }
                    }
                    else if (_ivr.action == 2) //play sound and dial extension
                    {
                        //impossible here
                    }
                    else if (_ivr.action == 3) //play sound and parent menu
                    {
                        //impossible here
                    }
                    /* //impossible here all
                    else if (_ivr.action == 4) //play sound(if available) and go hunt group
                    {
                    }
                    else if (_ivr.action == 5) //play sound(if available) and forward call to
                    {
                    }
                    else if (_ivr.action == 6) //play sound(if available) and go to "Monitor" group
                    {
                    }
                    else if (_ivr.action == 7) //play sound(if available) and go to "Ring group"
                    {
                    }
                    else if (_ivr.action == 8) //play sound(if available) and go to "Conference room"
                    {
                    }
                    else if (_ivr.action == 9) //play sound(if available) and go to "Voice mail box"
                    {
                    }
                    else if (_ivr.action == 10) //play sound(if available) and hung up
                    {
                    }
                    */
                }
            }
            else if (opAsync == _op_call_transfer)
            {
                //no matter IVR is which action
                //all can be same route
                if (_env.IsChanConnected(_chan.index))
                {
                    //the original channel is still connected
                    if (_op_call_transfer.getResult() == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                    {
                        //call transfered successfully.
                        if(_pbx.IsPBXChanInParkingSlot(_chan) == null)
                        {
                            if (!_op_call_transfer.trans_succeed)
                            {
                                if (_exten != null)
                                {
                                    toVMB(_exten);
                                }
                                else
                                {
                                    _env.DisconnectCall(_chan.index, _op_call_transfer.disc_code, _op_call_transfer.disc_desc, "PBX: call transfer failed in IVRMenu");
                                }
                            }
                            else
                            {
                                _env.DisconnectCall(_chan.index, _op_call_transfer.disc_code, _op_call_transfer.disc_desc, "PBX: call transfer succeed in IVRMenu");
                            }
                        }
                    }
                    else
                    {
                        //if hwCode == 1, then it is ring timeout
                        //anyway here if call transfer is not successful, go voicemail box if possible
                        if (!_op_call_transfer.trans_succeed)
                        {
                            if (_exten != null)
                            {
                                toVMB(_exten);
                            }
                            else
                            {
                                //shouldn't reach here
                                //for the IVR, the original call should already be connected
                                //if it is not in connected status anymore
                                //it means it got disconnected
                            }
                        }
                        else
                        {
                            //shouldn't reach here
                            //for the IVR, the original call should already be connected
                            //if it is not in connected status anymore
                            //it means it got disconnected
                        }

                    }
                }
            }
        }

        public List<string> getDTMFOptions()
        {
            List<string> dtmf_options = new List<string>();

            if (_ivr.dtmf_accept_exten)
            {
                for (int i = 0; i < _pbx.sip_exten.Count; i++)
                {
                    dtmf_options.Add(_pbx.sip_exten[i].UserName);
                }
            }

            for (int i = 0; i < _ivr.dtmfs.Count; i++)
            {
                dtmf_options.Add(_ivr.dtmfs[i].DTMFStr);
            }

            return dtmf_options;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpIVRMenu::start()########################====>>");

            if (_ivr == null)
            {
                _env.DisconnectCall(_chan.index, 0, "", "PBX: _ivr is null in start() of IVRMenu");
                return;
            }

            _op_audio_play = null;
            _op_dtmf_detect = null;
            _op_call_transfer = null;
            _chan.DTMFBuf = "";

            List<string> audio_files = new List<string>();
            audio_files.Add(_ivr.sound_file);

            List<string> dtmf_opts = getDTMFOptions();
            int max_digits = 0;
            for (int i = 0; i < dtmf_opts.Count; i++)
            {
                if (dtmf_opts[i].Length > max_digits)
                    max_digits = dtmf_opts[i].Length;
            }

            if (_ivr.action == 0) //nothing, no defined yet
            {
            }
            else if (_ivr.action == 1) //play sound and detect dtmf
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, dtmf_opts, max_digits, "#", 0);
                    _op_audio_play.timeout1 = _ivr.dtmf_accept_exten_wait_ms;
                    _op_audio_play.perform();
                }
                else
                {
                    _op_dtmf_detect = new GTOpDTMFDetect(this, _env, _chan, _chan.DTMFBuf, dtmf_opts, max_digits, "#", _ivr.menu_dtmf_wait_ms);
                    _op_dtmf_detect.timeout1 = _ivr.dtmf_accept_exten_wait_ms;
                    _op_dtmf_detect.perform();
                }
            }
            else if (_ivr.action == 2) //play sound and dial extension
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    if (!TryReachExtension(_ivr.transfer_to))
                    {
                        //extension is not right, hungup here
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: try reaching extension failed, hungup here in IVRMenu");
                    }
                }
            }
            else if (_ivr.action == 3) //play sound and goto another menu
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    //_ivr = _ivr.ParentIVRMenu;
                    SIPPBXIVR ivrmenu = _pbx.getIVRMenuByName(_ivr.transfer_to);
                    if (ivrmenu != null)
                    {
                        _ivr = ivrmenu;
                        start();
                    }
                    else
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: ivrmenu " + _ivr.transfer_to + " is null in IVRMenu");
                    }
                }
            }
            else if (_ivr.action == 4) //play sound(if available) and go hunt group
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    if (!TryReachACD(_ivr.transfer_to))
                    {
                        //extension is not right, hungup here
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: try reaching ACD " + _ivr.transfer_to + " failed in IVRMenu");
                    }
                }
            }
            else if (_ivr.action == 5) //play sound(if available) and forward call to
            {
            }
            else if (_ivr.action == 6) //play sound(if available) and go to "Monitor" group
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    if (!TryReachMonitorGroup(_ivr.transfer_to))
                    {
                        //extension is not right, hungup here
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: try reaching MonitorGroup " + _ivr.transfer_to + " failed in IVRMenu");
                    }
                }
            }
            else if (_ivr.action == 7) //play sound(if available) and go to "Ring group"
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    if (!TryReachRingGroup(_ivr.transfer_to))
                    {
                        //extension is not right, hungup here
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: try reaching RingGroup " + _ivr.transfer_to + " failed in IVRMenu");
                    }
                }
            }
            else if (_ivr.action == 8) //play sound(if available) and go to "Conference room"
            {
                if (_ivr.sound_file.Length > 0)
                {
                    //Do we really DTMF detection(condition) here? Need confirm
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, dtmf_opts, max_digits, "#", 0);
                    _op_audio_play.timeout1 = _ivr.dtmf_accept_exten_wait_ms;
                    _op_audio_play.perform();
                }
                else
                {
                    _pbx.SetChanIntoConferenceRoom(_env, _chan, _ivr.transfer_to, 1);
                }
            }
            else if (_ivr.action == 9) //play sound(if available) and go to "Voice mail box"
            {
                if (_ivr.sound_file.Length > 0)
                {
                    //Do we really DTMF detection(condition) here? Need confirm
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, dtmf_opts, max_digits, "#", 0);
                    _op_audio_play.timeout1 = _ivr.dtmf_accept_exten_wait_ms;
                    _op_audio_play.perform();
                }
                else
                {
                    if (_ivr.sound_file.Length > 0)
                    {
                        //Do we really DTMF detection(condition) here? Need confirm
                        _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, dtmf_opts, max_digits, "#", 0);
                        _op_audio_play.timeout1 = _ivr.dtmf_accept_exten_wait_ms;
                        _op_audio_play.perform();
                    }
                    else
                    {
                        if (!TryReachVoiceMailBox(_ivr.transfer_to))
                        {
                            //cannot reach this extension's voice mail box,
                            //nothing else can do, just hungup
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: try reaching VoiceMailBox " + _ivr.transfer_to + " failed in IVRMenu");
                        }
                    }
                }
            }
            else if (_ivr.action == 10) //play sound(if available) and hung up
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: sound file _ivr.sound_file is null in IVRMenu");
                }
            }
            else if (_ivr.action == 11) //play sound(if available) and run plugin
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    if (!TryRunPlugin(_ivr.transfer_to))
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: run plugin " + _ivr.transfer_to + " failed in IVRMenu");
                    }
                }
            }
            else if (_ivr.action == 12) //play sound and goto another diaplan
            {
                if (_ivr.sound_file.Length > 0)
                {
                    _op_audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                    _op_audio_play.perform();
                }
                else
                {
                    SIPPBXDialPlan dp = _pbx.getDialPlanByPlanName(_ivr.transfer_to);
                    if (dp != null)
                    {
                        _env.DoDialPlan(_chan.index, _chan, null, null);
                    }
                    else
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: dialplan " + _ivr.transfer_to + " is null in IVRMenu");
                    }
                }
            }
        }

        public void toVMB(SIPPBXExten extn)
        {
            SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, extn);
        }
    }
}
