using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpCallWait : GTOpAsync
    {
        public uint _msWaitTime;
        public int _Tag;

        public GTOpCallWait(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, uint msWaitTime, int tag)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            _msWaitTime = msWaitTime;
            _Tag = tag;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallWait!");

            if (getEnv().IsChanConnected(getPBXChan().index))
                getEnv().StartTimer(getPBXChan().index, _msWaitTime);
            else
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, 0);
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch == getPBXChan().index)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
            }
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);
            if (ch == getPBXChan().index)
            {
				getEnv().StopTimer(ch);
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, 0);
            }
        }
    }
}
