using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpCallPickup : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public PickUpGroup _pg;
        public SIPPBXChan _chan;
        public SIPPBXChan _chan1;
        public SIPPBXChan pbxChanOrg;

        public GTOpAnswerCall _op_answercall;

        public GTOpCallPickup(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, PickUpGroup pg, SIPPBXChan pbxChan1)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _pg = pg;
            _chan1 = pbxChan1;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallPickup::start()########################====>>");

            pbxChanOrg = _chan1.link_chan;

            if (pbxChanOrg == null)
            {
                done(null, GTOpAsync.ResultCode.OP_RESULT_ERROR, 0);
                return;
            }

            //2015-03-03  ####BUG FIX####
            //check if the original channel is having a ringing group op
            //if it does, which means it must have multiple ringing extensions, so we need to cancel them all
            if (pbxChanOrg.async_op_compound != null)
            {
                GTOpRingGroup rgop = pbxChanOrg.async_op_compound as GTOpRingGroup;
                if (rgop != null)
                {
                    _env.LOG_Trace(4, "GTOpCallPickup cast to ringgroup object successfully!");

                    if (rgop.op_ringgroup_dial != null && rgop.op_answercall == null && rgop.op_call_connect == null)
                    {
                        //still in ringing status
                        if (rgop.op_ringgroup_dial.trans_chans.Count > 0)
                        {
                            _env.StopTimer(pbxChanOrg.index);

                            if (rgop._rg.ringType == 0) //ring all
                            {
                                for (int i = 0; i < rgop.op_ringgroup_dial.trans_chans.Count; i++)
                                {
                                    if (rgop.op_ringgroup_dial.trans_chans[i].index != pbxChanOrg.index && rgop.op_ringgroup_dial.trans_chans[i].index != _chan1.index)
                                        _env.DisconnectCall(rgop.op_ringgroup_dial.trans_chans[i].index, 0, "", "PBX: disconnecting in CallPickupGroup of RingGroup because another channel got connected");
                                }

                                rgop.op_ringgroup_dial.trans_chans.Clear();
                            }
                            else //ring by order
                            {
                                //trans_chans already has the one dialing
                            }
                        }
                    }
                }
                else
                {
                    _env.LOG_Trace(4, "GTOpCallPickup cast to ringgroup object failed! Means the original channel is not in ringgroup operation.");
                }

                //taking over the asy-op
                pbxChanOrg.async_op_compound = null;
                pbxChanOrg.dp = null;
            }


            //connect two channels
            pbxChanOrg.link_chan = _chan;
            _chan.link_chan = pbxChanOrg;

            //disconnect the ringing channel
            _chan1.link_chan = null;
            _env.DisconnectCall(_chan1.index, 0, "", "PBX: disconnect the ringing channel in CallPickup");

            if (_env.GetChannel(pbxChanOrg.index).ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED)
            {
                _op_answercall = new GTOpAnswerCall(this, _env, pbxChanOrg);
                _op_answercall.perform();
                return;
            }
            else if(_env.IsChanConnected(pbxChanOrg.index))
            {
                //_env.Send_StopAudio(pbxChanOrg.index);
                _env.Send_StopAudioEx(pbxChanOrg.index, 1, "");
                pbxChanOrg.async_op_compound = new GTOpCallBridge(_pbx, _env, pbxChanOrg, _chan);
                pbxChanOrg.async_op_compound.start();
                done(null, GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
            }
            else 
            {
                done(null, GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
            }

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
            {
                if (opAsync == _op_answercall && opAsync != null)
                {
                    pbxChanOrg.async_op_compound = new GTOpCallBridge(_pbx, _env, pbxChanOrg, _chan);
                    pbxChanOrg.async_op_compound.start();
                }
            }
            else
            {

                if (opAsync == _op_answercall)
                {
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: answercall is done in CallPickup");
                }
                else
                {
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: error in CallPickup");
                }
            }

            _chan.async_op_compound = null;
        }


    }
}
