using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpCallPark : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXParkingSlot _ps;
        public SIPPBXChan _chan;
        public GTOpDTMFDetect _op_dtmf_detect;

        public GTOpCallPark(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXParkingSlot ps)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _ps = ps;
            _op_dtmf_detect = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallPark::start()########################====>>");

            _ps.pbxChan = _chan;

            if (_ps.playMOH)
            {
                _env.Send_StartMusicOnHold(_chan.index, _ps.mohDir, _pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
            }

            if ((_ps.vmb != null && _ps.vmbDTMF.Length > 0) || 
                (_ps.dpDTMF.Length > 0 && _ps.dpName.Length > 0) || _ps.waitTimeout > 0)
            {
                List<string> dtmf_opts = new List<string>();

                if(_ps.vmbDTMF.Length> 0)
                    dtmf_opts.Add(_ps.vmbDTMF);

                if(_ps.dpDTMF.Length > 0)
                    dtmf_opts.Add(_ps.dpDTMF);

                _op_dtmf_detect = new GTOpDTMFDetect(this, _env, _chan, _chan.DTMFBuf, dtmf_opts, 0, "", _ps.waitTimeout * 1000);
                _op_dtmf_detect.perform();
            }
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_dtmf_detect)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_ps.playMOH)
                        _env.Send_StopMusicOnHold(_chan.index);

                    if (_op_dtmf_detect.getDTMFStr().Contains(_ps.vmbDTMF) && _ps.vmbDTMF.Length > 0)
                    {
                        _chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, _ps.vmb);
                        _chan.async_op_compound.start();
                    }
                    else if (_op_dtmf_detect.getDTMFStr().Contains(_ps.dpDTMF) && _ps.dpDTMF.Length > 0)
                    {
                        SIPPBXDialPlan dp = _env.pbx.getDialPlanByPlanName(_ps.dpName);

                        if (dp != null)
                        {
                            _chan.dp = dp;
                            _env.DoDialPlan(_chan.index, _chan, null, null);
                        }
                    }
                }
                else if (result == GTOpAsync.ResultCode.OP_RESULT_TIMEOUT)
                {
                    if (_ps.waitTimeoutTo.Length == 0)
                    {
                        if (_ps.vmb != null)
                        {
                            if (_ps.playMOH)
                                _env.Send_StopMusicOnHold(_chan.index);

                            _chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, _ps.vmb);
                            _chan.async_op_compound.start();
                        }
                        else
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: parkslot vmb is null in CallPark");
                        }
                    }
                    else
                    {
                        SIPPBXDialPlan dp = _env.pbx.getDialPlanByPlanName(_ps.dpName);

                        if (dp != null)
                        {
                            _chan.dp = dp;
                            _env.DoDialPlan(_chan.index, _chan, null, null);
                        }
                        else
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: parkslot dialplan is null in CallPark");
                        }
                    }
                }
                else
                {
                }
            }

        }
    }
}
