using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpCallBridge : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXChan _chan1;
        public GTOpCallConnect _op_callconnect;

        public GTOpCallBridge(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXChan pbxChan1)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _chan1 = pbxChan1;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallBridge::start()########################====>>");

            _op_callconnect = new GTOpCallConnect(this, _env, _chan, _chan1, null);
            _op_callconnect.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_callconnect)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                }
                else
                {
                    //disconnect on both,
                    //shouldn't reach this
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: disconnect on both, shouldn't reach this in done of CallBridge");
                    _env.DisconnectCall(_chan1.index, 0, "", "PBX: disconnect on both, shouldn't reach this in done of CallBridge");
                }
            }
        }


    }

/* //commented out because same as GTOpCallBridge
    class GTOpCallBridgeCmd : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXChan _chan1;
        public GTOpCallConnect _op_acd_callconnect;

        public GTOpCallBridgeCmd(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXChan pbxChan1)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _chan1 = pbxChan1;
        }

        public override void start()
        {
            base.start();

            _op_acd_callconnect = new GTOpCallConnect(this, _env, _chan, _chan1);
            _op_acd_callconnect.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_acd_callconnect)
            {
            }
        }
    }
 */ 
}
