using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpAudioRecord : GTOpAsync
    {
        public string audio_fn;
        public int max_digits;
        public string term_str;
        public int time_out;

        public GTOpAudioRecord(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string audioFile, int maxDigits, string termStr, int timeOut)
            : base(ac, env, pbx_chan, pbx_chan.DTMFBuf)
        {
            audio_fn = audioFile;
            max_digits = maxDigits;
            term_str = termStr;
            time_out = timeOut;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpAudioRecord!");
            getEnv().Send_RecordAudio(getPBXChan().index, audio_fn, max_digits, term_str, time_out, 0);
        }

        public override void abort()
        {
            base.abort();
            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting recording audio in GTOpAudioRecord");
                //getEnv().Send_StopAudio(getPBXChan().index);
                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch != getPBXChan().index)
                return;
            
            fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
        }

        public override void On_RecvAudioRecordDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioRecordDone(ch, doneReason, dtmfBuffer);

            if (ch != getPBXChan().index)
                return;

            _dtmf = dtmfBuffer;

            switch (doneReason)
            {
                case 0: //GT_AUDIO_DONE_DTMF_TIMEOUT
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    break;
                case 1: //GT_AUDIO_DONE_DTMF_MAX_DIGITS
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
                    break;
                case 2: //GT_AUDIO_DONE_DTMF_DIGIT_DETECTED
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 2);
                    break;
                case 4: //GT_AUDIO_DONE_RECORD
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 3);
                    break;
                case 5: //GT_AUDIO_DONE_FORCED_STOP
                    if (isAborting())
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                    else
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 5);
                    break;
            }

        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            if (ch != getPBXChan().index)
                return;

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, errCode);
        }

    }
}
