using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpAudioPlayEx : GTOpAsync
    {
        public List<string> audio_file_list;
        public List<string> dtmf_options_list;
        public int max_digits;
        public string term_str;
        public int time_out;
        public bool dtmf_matched;
        public bool audio_playing;
        public bool dtmf_done;
        public GTOpAsync.ResultCode dtmf_done_result;
        public int dtmf_done_res_code;
        public int timeout1; //when multiple choices matched in DTMF, this timeout is used to wait for next digit.
        public int extra_dtmf_timeout;
        public bool stop_playing_audio_for_first_dtmf_key;

        public GTOpAudioPlayEx(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, List<string> a_f, List<string> d_o, int maxDigits, string termStr, int timeOut, bool stop_playing)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            audio_file_list = a_f;
            dtmf_options_list = d_o;
            max_digits = maxDigits;
            term_str = termStr;
            time_out = timeOut;
            dtmf_matched = false;
            audio_playing = false;
            timeout1 = 1600;
            dtmf_done = false;
            dtmf_done_result = ResultCode.OP_RESULT_SUCCESS;
            dtmf_done_res_code = 0;
            extra_dtmf_timeout = 8000;
            stop_playing_audio_for_first_dtmf_key = stop_playing;
        }

        public bool isDTMFMatched()
        {
            return dtmf_matched;
        }

        public override void beginOp()
        {
            base.beginOp();

            LogoutText(4, "Start perform asyncronized step - GTOpAudioPlayEx!");

            if (!getEnv().IsChanConnected(getPBXChan().index))
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);

            if (audio_file_list == null)
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, -1);

            getEnv().Send_ClearAudio(getPBXChan().index);

            for (int i = 0; i < audio_file_list.Count; i++)
            {
                getEnv().Send_AddAudio(getPBXChan().index, audio_file_list[i], 0);
            }

            getEnv().Send_PlayAudio(getPBXChan().index, "", 0, "", 0, 0);

            audio_playing = true;

            if (max_digits != 0 || term_str.Length > 0 || time_out != 0)
                getEnv().Send_EnableDTMF(getPBXChan().index, max_digits, term_str, time_out);

        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting playing audio in GTOpAudioPlay");
                if (audio_playing)
                {
                    //getEnv().Send_StopAudio(getPBXChan().index);
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                    audio_playing = false;
                }

                if (max_digits != 0 || term_str.Length > 0 || time_out != 0)
                    getEnv().Send_DisableDTMF(getPBXChan().index);
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }



        public override void On_RecvDTMFDone(int ch, int doneReason, string dtmfBuf)
        {
            base.On_RecvDTMFDone(ch, doneReason, dtmfBuf);

            if (ch != getPBXChan().index)
                return;

            dtmf_done = true;

            getEnv().LOG_Trace(4, "GTOpAudioPlayEx::On_RecvDTMFDone, _dtmf(" + _dtmf + ") and DTMF buffer(" + dtmfBuf + ")");

/*
            if (_dtmf != dtmfBuf)
            {
                getEnv().LOG_Trace(4, "DTMF Done event received, but GTOpAudioPlayEx's dtmf(" + _dtmf +") buffer is not equal to the DTMF buffer(" + dtmfBuf+") passed by this event!" );
                _dtmf = dtmfBuf;
            }
*/

            switch (doneReason)
            {
                case 0: // = DTMF_DONE_TIMEOUT,
                    dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_TIMEOUT;
                    dtmf_done_res_code = 0;
                    break;
                case 1: // = DTMF_DONE_MAX_DIGITS,
                    getDTMFResult(dtmfBuf);
                    if(dtmf_matched)
                        dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_SUCCESS;
                    else
                        dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_ERROR;
                    dtmf_done_res_code = 1;
                    break;
                case 2: // = DTMF_DONE_DIGIT_DETECTED,
                    char[] argTermStr = new char[term_str.Length];
                    for (int i = 0; i < term_str.Length; i++)
                        argTermStr[i] = term_str[i];
                    getDTMFResult(dtmfBuf.TrimEnd(argTermStr));
                    if (dtmf_matched)
                        dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_SUCCESS;
                    else
                        dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_ERROR;
                    dtmf_done_res_code = 2;

                    //as _dtmf doesn't have term digits, here we set it to driver's dtmf buffer
                    _dtmf = dtmfBuf;
                    break;
            }

            if (audio_playing)
            {
                //getEnv().Send_StopAudio(ch);
                getEnv().Send_StopAudioEx(ch, 1, "");
                audio_playing = false;
            }
            else
            {
                fireDone(dtmf_done_result, dtmf_done_res_code);
            }
        }

        public override void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);

            if (ch != getPBXChan().index)
                return;

            switch (doneReason)
            {
/*
                case 0: //GT_AUDIO_DONE_DTMF_TIMEOUT
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_TIMEOUT, 0);
                    break;
                case 1: //GT_AUDIO_DONE_DTMF_MAX_DIGITS
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
                    break;
                case 2: //GT_AUDIO_DONE_DTMF_DIGIT_DETECTED
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 2);
                    break;
 */
                case 3: //GT_AUDIO_DONE_PLAY
                    audio_playing = false;
                    break;
                case 5: //GT_AUDIO_DONE_FORCED_STOP
                    audio_playing = false;
                    break;
            }

            if (dtmf_done)
            {
                fireDone(dtmf_done_result, dtmf_done_res_code);
            }
            else
            {
                //still need DTMF
                if (time_out == 0)
                {
                    //didn't specify the timer on DTMF connection, so we need to last for a while(extra_dtmf_timeout)
                    //DON'T KNOW HOW TO IMPLEMENT THIS HERE
                    //BECAUSE THERE IS ONLY ONE TIMER
                }
            }
        }

        public void getDTMFResult(string dtmfValue)
        {
            for (int i = 0; i < dtmf_options_list.Count; i++)
            {
                if (dtmf_options_list[i] == dtmfValue)
                {
                    dtmf_matched = true;
                    break;
                }
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch != getPBXChan().index)
                return;

            if (dtmf_options_list == null)
                return;

            bool called_stop_audio = false;
            bool called_stop_audio_because_first_dtmf_key = false;

            getEnv().StopTimer(getPBXChan().index);

            //Stop playing audio when first DTMF is pressed.(sometimes clients want this)
            //make it an option in the code
            if (audio_playing && stop_playing_audio_for_first_dtmf_key)
            {
                //getEnv().Send_StopAudio(getPBXChan().index);
                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                audio_playing = false;
                getEnv().LOG_Trace(4, "Stop playing audio in GTOpAudioPlayEx::On_RecvDTMFKeyUp because stop_playing_audio_for_first_dtmf_key is true");
                called_stop_audio = true;

                //###2016-09-11 note: found a bug here: if we don't wait for a bit, 
                //as we have set audio_playing is false and called_stop_audio is true, 
                //it will immediately call firedone if the dtmf matchs.
                //the stop_audio event will be passed to next object

                called_stop_audio_because_first_dtmf_key = true;
            }

            char keyChar = Convert.ToChar(keyValue);

            if (term_str.Length > 0)
            {
                if (term_str.IndexOf(keyChar) >= 0)
                {
                    //here we don't append key which is in term string
                }
                else
                    _dtmf += keyChar;
            }
            else
                _dtmf += keyChar;

            int num_of_match = 0;
            int num_of_equal = 0;

            for (int i = 0; i < dtmf_options_list.Count; i++)
            {
                if (dtmf_options_list[i].IndexOf(_dtmf) == 0)
                    num_of_match++;

                if (dtmf_options_list[i] == _dtmf)
                    num_of_equal++;
            }

            if (num_of_equal > 0)
            {
                if (num_of_match == 1)
                {
                    dtmf_matched = true;

                    bool need_firedone = false;

                    if (max_digits == 0)
                    {
                        if (term_str.Length == 0)
                        {
                            need_firedone = true;
                        }
                        else if (term_str.IndexOf(keyChar) < 0)
                        {
                            need_firedone = true;
                        }
                        else
                        {
                            //the case term string is not null, and the key is not in term string
                            //we should still wait until the term key reached.
                            //so we do nothing here
                        }
                    }
                    else
                    {
                        if (_dtmf.Length < max_digits)
                        {
                            if (term_str.Length == 0)
                            {
                                need_firedone = true;
                            }
                            else if (term_str.IndexOf(keyChar) < 0)
                            {
                                need_firedone = true;
                            }
                            else
                            {
                                //the case term string is not null, and the key is not in term string
                                //we should still wait until the term key reached.
                                //so we do nothing here
                            }
                        }
                    }

                    if (need_firedone)
                    {
                        //is not one of the term_str, also
                        //not reached DTMF end condition, so we need to fire done ourself
                        dtmf_done = true;
                        dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_SUCCESS;
                        dtmf_done_res_code = 0;

                        if (!called_stop_audio)
                        {
                            if (!called_stop_audio_because_first_dtmf_key)
                            {
                                if (audio_playing)
                                {
                                    //getEnv().Send_StopAudio(getPBXChan().index);
                                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                    audio_playing = false;
                                    getEnv().LOG_Trace(4, "Stop playing audio in GTOpAudioPlayEx::On_RecvDTMFKeyUp");
                                }
                                else
                                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                            }
                        }
                    }
 
                }
                else if (num_of_match > 1)
                {
                    getEnv().LOG_Trace(4, "Starting timer in GTOpAudioPlayEx::On_RecvDTMFKeyUp");
                    getEnv().StartTimer(getPBXChan().index, (uint)timeout1);
                }
            }
        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            if (ch != getPBXChan().index)
                return;

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, errCode);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch != getPBXChan().index)
                return;

            getEnv().StopTimer(getPBXChan().index);

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch != getPBXChan().index)
                return;

            dtmf_matched = true;
            dtmf_done = true;
            dtmf_done_result = GTOpAsync.ResultCode.OP_RESULT_SUCCESS;
            dtmf_done_res_code = 0;
            if (audio_playing)
            {
                getEnv().LOG_Trace(4, "Stop playing audio in On_Timer");
                //getEnv().Send_StopAudio(getPBXChan().index);
                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                audio_playing = false;
            }
            else
                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
        }
    }


}
