/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpAudioPlay : GTOpAsync
    {
        public bool audio_played;
        public List<string> audio_file_list;
        public List<string> dtmf_options_list;
        public int max_digits;
        public string term_str;
        public int time_out;
        public bool dtmf_matched;
        public int timeout1; //when multiple choices matched in DTMF, this timeout is used to wait for next digit. in milliseconds.
        public SIPPBXChan monitor_chan;

        public GTOpAudioPlay(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, List<string> a_f, List<string> d_o, int maxDigits, string termStr, int timeOut)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            audio_file_list = a_f;
            dtmf_options_list = d_o;
            max_digits = maxDigits;
            term_str = termStr;
            time_out = timeOut;
            dtmf_matched = false;
            timeout1 = 1600;
            audio_played = false;
            monitor_chan = null;
        }

        public bool isDTMFMatched()
        {
            return dtmf_matched;
        }

        public override void beginOp()
        {
            base.beginOp();

            LogoutText(4, "Start perform asyncronized step - GTOpAudioPlay!");

            if(audio_file_list == null)
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, -1);

            GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(getPBXChan().index);

            if (apiChan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED)
            {
                SIPPBXWinUtil.SetChanAudioCodec(_pbxChan.link_exten, _env, _env.pbx, _pbxChan, null);
                getEnv().Send_Answer(getPBXChan().index);
            }
            else if (getEnv().IsChanConnected(getPBXChan().index))
            {
                getEnv().Send_ClearAudio(getPBXChan().index);

                for (int i = 0; i < audio_file_list.Count; i++)
                {
                    getEnv().Send_AddAudio(getPBXChan().index, audio_file_list[i], 0);
                }

                getEnv().Send_PlayAudio(getPBXChan().index, "", max_digits, term_str, time_out, 0);

                audio_played = true;
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            if (ch == getPBXChan().index && !audio_played)
            {
                getEnv().Send_ClearAudio(getPBXChan().index);

                for (int i = 0; i < audio_file_list.Count; i++)
                {
                    getEnv().Send_AddAudio(getPBXChan().index, audio_file_list[i], 0);
                }

                getEnv().Send_PlayAudio(getPBXChan().index, "", max_digits, term_str, time_out, 0);

                audio_played = true;
            }
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting playing audio in GTOpAudioPlay");
                //getEnv().Send_StopAudio(getPBXChan().index);
                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);

            if(ch != getPBXChan().index)
                return;

            switch (doneReason)
            {
                case 0: //GT_AUDIO_DONE_DTMF_TIMEOUT
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_TIMEOUT, 0);
                    break;
                case 1: //GT_AUDIO_DONE_DTMF_MAX_DIGITS
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
                    break;
                case 2: //GT_AUDIO_DONE_DTMF_DIGIT_DETECTED
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 2);
                    break;
                case 3: //GT_AUDIO_DONE_PLAY
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 3);
                    break;
                case 5: //GT_AUDIO_DONE_FORCED_STOP
                    if (isAborting())
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                    else
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 5);
                    break;
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch != getPBXChan().index)
                return;

            if (dtmf_options_list == null)
                return;

            getEnv().StopTimer(getPBXChan().index);

            char keyChar = Convert.ToChar(keyValue);

            if(term_str.Length > 0)
            {
                if(term_str.IndexOf(keyChar) >= 0)
                {
                }
                else 
                    _dtmf += keyChar;
            }
            else
                _dtmf += keyChar;

            int num_of_match = 0;
            int num_of_equal = 0;

            for (int i = 0; i < dtmf_options_list.Count; i++)
            {
                if (dtmf_options_list[i].IndexOf(_dtmf) == 0)
                    num_of_match++;

                if (dtmf_options_list[i] == _dtmf)
                    num_of_equal++;
            }

            if (num_of_equal > 0)
            {
                if (num_of_match == 1)
                {
                    dtmf_matched = true;
                    getEnv().LOG_Trace(4, "Stop playing audio in On_RecvDTMFKeyUp");
                    //getEnv().Send_StopAudio(getPBXChan().index);
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                }
                else if (num_of_match > 1)
                {
                    getEnv().LOG_Trace(4, "Starting timer in On_RecvDTMFKeyUp");
                    getEnv().StartTimer(getPBXChan().index, (uint)timeout1);
                }
            }
        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            if(ch != getPBXChan().index)
                return;

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, errCode);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (monitor_chan != null)
            {
                if (monitor_chan.index == ch)
                {
                    monitor_chan = null;
                    return;
                }
            }

            if (ch != getPBXChan().index)
                return;

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch != getPBXChan().index)
                return;

            getEnv().LOG_Trace(4, "Stop playing audio in On_Timer");
            //getEnv().Send_StopAudio(getPBXChan().index);
            getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
            dtmf_matched = true;
        }

    }

}
