/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpAsyncCompound
    {
        public GTOpAsync op;

        public GTOpAsyncCompound()
        {
            op = null;
        }

        public virtual void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
        }

        public virtual void start()
        {
        }
    }

    public class GTOpAsync
    {
        public GTOpAsync(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbxChan, string dtmfStr)
        {
            _async_compund = ac;
            _result = ResultCode.OP_RESULT_UNDEFINED;
            _hwStatus = 0;
            _isDone = false;
            _bAborting = false;
            _iPerformCount = 0;
            _env = env;
            _pbxChan = pbxChan;
            _dtmf = dtmfStr;
        }

        public GTSIPPBXEnv getEnv() 
        { 
            return _env; 
        }

        public SIPPBXChan getPBXChan()
        {
            return _pbxChan;
        }

        public string getDTMFStr()
        {
            return _dtmf;
        }

        public void LogoutText(int logLevel, string logText)
        {
            if(_env != null)
                _env.LOG_Trace(logLevel, logText);
        }

        public enum ResultCode
        {
            OP_RESULT_UNDEFINED = -1,
            OP_RESULT_SUCCESS,
            OP_RESULT_ABORTED,
            OP_RESULT_TIMEOUT,
            OP_RESULT_ERROR
        };

	    /////////////////////////////////////////////////////////////////////////
	    /** Perform the asynchronous operation.
	    */
    	public virtual void perform()
        {
            _result = ResultCode.OP_RESULT_UNDEFINED;
            _isDone = false;
            _bAborting = false;
            ++_iPerformCount;
            _async_compund.op = this;
            beginOp();
        }

	    /////////////////////////////////////////////////////////////////////////
	    /** Child classes override this to provide their "kick-off" code.
	    */
	    public virtual void beginOp()
        {
        }

	    /////////////////////////////////////////////////////////////////////////
	    /** Child classes override this to provide the ability to abort the
	    //	operation.
	    */
        public virtual void abort()
        {
        }

	    public ResultCode getResult() {return _result;}
	    public int getHwCode() {return _hwStatus;}

	    /////////////////////////////////////////////////////////////////////////
	    /** \return Whether or not the operation is done.
	    */
	    public bool isDone() {return _isDone;}

        public bool isAborting() { return _bAborting; }

        /////////////////////////////////////////////////////////////////////////
	    /** \return The number of times this operation has been performed.
	    */
	    public int getPerformCount() {return _iPerformCount;}

	    /////////////////////////////////////////////////////////////////////////
	    /** Called by child classes to signal the operation is complete and 
	    //	call back on the owner's callback.
	    */
        protected void fireDone()
        {
            if (_isDone)
            {
                return;
            }

            _async_compund.op = null;
            _isDone = true;
            _async_compund.done(this, getResult(), getHwCode());
        }

        protected void fireDone(ResultCode result, int hwStatus)
        {
            _env.LOG_Trace(4, "Fired done " + result.ToString() + " " + hwStatus.ToString());
            setResult(result);
            setHwCode(hwStatus);
            fireDone();
        }

	    /////////////////////////////////////////////////////////////////////////
	    /** \return The generic operation result code.
	    */
	    protected void setResult(ResultCode result) {_result = result;}

	    /////////////////////////////////////////////////////////////////////////
	    /** Set the hardware status code for this operation.  This is writeable
	    //	only when transitioning from GT_SUCCESS to non-GT_SUCCESS so that 
	    //	the first operation to give a non success will be the remembered 
	    //	result for the whole operation. (and not overwritten by subsequent 
	    //	actions).
	    //*/
	    protected void setHwCode(int hwStatus) {if(0 == _hwStatus) _hwStatus = hwStatus;}

	    /// The end result of the operation.
	    protected ResultCode      _result;

	    /// The hardware status code
	    protected int		        _hwStatus;

	    /// A running count of the number of times this operation has been
	    /// "performed".  Whether it is valid to perform the same operation
	    ///	multiple times or not is up to the child class implementation.
	    protected int				_iPerformCount;

	    /// Flag to indicate if the operation is done or not.
	    protected bool			_isDone;

        /// Flag to remember if we're aborting or not
        protected bool          _bAborting;

        protected GTSIPPBXEnv     _env;
        protected SIPPBXChan      _pbxChan;
        protected string          _dtmf;

        protected GTOpAsyncCompound _async_compund;

//**************************************************************************************
//***********************Events*********************************************************
//**************************************************************************************

        public virtual void On_RecvConnected(int ch)
        {
        }

        public virtual void On_RecvOffered(int ch, string sCaller, string sCallee, string sDestAddr, string sViaAddr, string sFromIP, ushort nFromPort)
        {
        }

        public virtual void On_RecvDialing(int ch, string sCaller, string sCallee)
        {
        }

        public virtual void On_RecvRinging(int ch)
        {
        }

        public virtual void On_RecvIdle(int ch, int code, string desc)
        {
            _env.pbx.chan_list[ch].SetDiscReason(_env, desc);
        }

        public virtual void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
        }

        public virtual void On_RecvAudioRecordDone(int ch, int doneReason, string dtmfBuffer)
        {
        }

        public virtual void On_RecvConfAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
        }

        public virtual void On_RecvConfAudioRecordDone(int ch, int doneReason, string dtmfBuffer)
        {
        }

        public virtual void On_RecvAudioStatus(int ch, int resType, int statusCode)
        {
        }

        public virtual void On_RecvDTMFDone(int ch, int doneReason, string dtmfBuf)
        {
        }

        public virtual void On_RecvDTMFKeyDown(int ch, byte keyValue, uint ticks)
        {
        }

        public virtual void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
        }

        public virtual void On_RecvStatus(int chBegin, int chEnd, int chStatus)
        {
        }

        public virtual void On_RecvRegStatus(int user_id, int status, int regtime)
        {
        }

        public virtual void On_RecvError(int ch, int errCode)
        {
        }

        public virtual void On_RecvHolding(int ch, int hold_on)
        {
        }

        public virtual void On_RecvTransfering(int ch, string sAddr, string sReplaceCallID, string sReplaceFromTag, string sReplaceToTag)
        {
        }

        public virtual void On_RecvNotifySimpleMsgSummary(string sMsgWaiting, string sMsgAccount, string sVoiceMsg)
        {
        }

        public virtual void On_Timer(int ch)
        {
        }

        public virtual void On_RecvSessionProgress(int ch)
        {
        }

    }
}
