﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SIPPBXGUI
{
    public partial class UserList : Form
    {
        public PBXMainForm mainForm;

        public UserList()
        {
            InitializeComponent();

            mainForm = null;
        }

        private void UserList_Load(object sender, EventArgs e)
        {
            lvUserList.Columns.Clear();
            lvUserList.Columns.Add("User", 120, HorizontalAlignment.Left);
            lvUserList.Columns.Add("Permit", 120, HorizontalAlignment.Left);

            cbEnable.Checked = mainForm.UserPermitEnabled == 1;

            ShowUserList();
        }

        public void ShowUserList()
        {
            lvUserList.Items.Clear();

            for (int i = 0; i < mainForm.Users.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(mainForm.Users[i].userName);
                if(mainForm.Users[i].permit == 0)
                    aItem.SubItems.Add("Admin");
                else if (mainForm.Users[i].permit == 1)
                    aItem.SubItems.Add("User");
                else
                    aItem.SubItems.Add("Viewer");

                lvUserList.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            UserAcct act = new UserAcct();

            UserEdit dlg = new UserEdit();
            dlg.act = act;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                mainForm.Users.Add(act);
                ShowUserList();
                mainForm.SaveConfigToRegsitry();
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvUserList.SelectedIndices.Count > 0)
            {
                int idx = lvUserList.SelectedIndices[0];

                if (idx >= 0 && idx < mainForm.Users.Count)
                {

                    UserEdit dlg = new UserEdit();
                    dlg.act = mainForm.Users[idx];

                    if (dlg.ShowDialog() == DialogResult.OK)
                    {
                        ShowUserList();

                        if (mainForm.UserPermitEnabled == 1)
                        {
                            bool fndAdmin = false;
                            for (int i = 0; i < mainForm.Users.Count; i++)
                            {
                                if (mainForm.Users[i].permit == 0)
                                {
                                    fndAdmin = true;
                                    break;
                                }
                            }

                            if (!fndAdmin)
                            {
                                MessageBox.Show("Must define one Admin user in order to enable it", "Error");
                                cbEnable.Checked = false;
                                mainForm.UserPermitEnabled = 0;
                            }
                        }

                        mainForm.SaveConfigToRegsitry();
                    }
                }
                else
                {
                    MessageBox.Show("Selected user is out of range of users in list");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvUserList.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                int idx = lvUserList.SelectedIndices[0];
                if (idx >= 0 && idx < mainForm.Users.Count)
                {
                    mainForm.Users.RemoveAt(idx);

                    if (mainForm.UserPermitEnabled == 1)
                    {
                        bool fndAdmin = false;
                        for (int i = 0; i < mainForm.Users.Count; i++)
                        {
                            if (mainForm.Users[i].permit == 0)
                            {
                                fndAdmin = true;
                                break;
                            }
                        }

                        if (!fndAdmin)
                        {
                            MessageBox.Show("Must define one Admin user in order to enable it", "Error");
                            cbEnable.Checked = false;
                            mainForm.UserPermitEnabled = 0;
                        }
                    }

                    ShowUserList();
                    mainForm.SaveConfigToRegsitry();
                }
                else
                {
                    MessageBox.Show("Selected user is out of range", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void cbEnable_CheckedChanged(object sender, EventArgs e)
        {
            if (cbEnable.Checked)
            {
                if (mainForm.Users.Count > 0)
                {
                    bool fndAdmin = false;
                    for (int i = 0; i < mainForm.Users.Count; i++)
                    {
                        if (mainForm.Users[i].permit == 0)
                        {
                            fndAdmin = true;
                            break;
                        }
                    }

                    if (!fndAdmin)
                    {
                        MessageBox.Show("Must define one Admin user in order to enable it", "Error");
                        cbEnable.Checked = false;
                    }
                    else
                    {
                        mainForm.UserPermitEnabled = 1;
                    }
                }
                else
                {
                    MessageBox.Show("No user defined", "Error");
                    cbEnable.Checked = false;
                }
            }
            else
            {
                mainForm.UserPermitEnabled = 0;
            }

            mainForm.SaveConfigToRegsitry();
        }
    }
}
