using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ServerFoldersForm : Form
    {
        public SIPPBX pbx;

        public ServerFoldersForm()
        {
            InitializeComponent();

        }

        private void ServerFoldersForm_Load(object sender, EventArgs e)
        {
            tbMohDir.Text = pbx.moh_dir;
            tbLogFolder.Text = pbx.log_dir;
            switch (pbx.log_level)
            {
                case 0:
                    rbDisable.Checked = true;
                    break;
                case 1:
                    rbError.Checked = true;
                    break;
                case 2:
                    rbAlert.Checked = true;
                    break;
                case 3:
                    rbDebug.Checked = true;
                    break;
                case 4:
                    rbFull.Checked = true;
                    break;
            }
            tbReportFolder.Text = pbx.report_dir;
            tbRecordingFolder.Text = pbx.record_dir;
            tbVMBFolder.Text = pbx.vmb_dir;
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a music folder";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbMohDir.Text = SIPPBXWinUtil.AddFolderDashForDir(myBrowser.DirectoryPath);
            }

        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            pbx.moh_dir = SIPPBXWinUtil.AddFolderDashForDir(tbMohDir.Text);
            pbx.log_dir = SIPPBXWinUtil.AddFolderDashForDir(tbLogFolder.Text);
            if (rbDisable.Checked)
                pbx.log_level = 0;
            if (rbError.Checked)
                pbx.log_level = 1;
            if (rbAlert.Checked)
                pbx.log_level = 2;
            if (rbDebug.Checked)
                pbx.log_level = 3;
            if (rbFull.Checked)
                pbx.log_level = 4;
            pbx.report_dir = SIPPBXWinUtil.AddFolderDashForDir(tbReportFolder.Text);
            pbx.record_dir = SIPPBXWinUtil.AddFolderDashForDir(tbRecordingFolder.Text);
            pbx.vmb_dir = SIPPBXWinUtil.AddFolderDashForDir(tbVMBFolder.Text);

            DialogResult = DialogResult.OK;

            Close();
        }

        private void btnLogFolderBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a folder to save logs";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbLogFolder.Text = SIPPBXWinUtil.AddFolderDashForDir(myBrowser.DirectoryPath);
            }

        }

        private void btnReportFolderBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a folder to save reports";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbReportFolder.Text = SIPPBXWinUtil.AddFolderDashForDir(myBrowser.DirectoryPath);
            }
        }

        private void btnRecordingBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a folder to save recording files";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbRecordingFolder.Text  = SIPPBXWinUtil.AddFolderDashForDir(myBrowser.DirectoryPath);
            }
        }

        private void btnVMBBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a folder to save voice mail recording files";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbVMBFolder.Text = SIPPBXWinUtil.AddFolderDashForDir(myBrowser.DirectoryPath);
            }
        }

    }
}