﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SecurityList : Form
    {
        public SIPPBX pbx;

        public SecurityList()
        {
            InitializeComponent();
        }

        private void SecurityList_Load(object sender, EventArgs e)
        {
            //mtbIPAddr.Mask = "###.###.###.###";
            //mtbIPAddr.ValidatingType = typeof(System.Net.IPAddress);

            for (int i = 0; i < pbx.IPFilterList.Count; i++)
            {
                IPFilter filter = pbx.IPFilterList[i];
                if (filter.WhiteOrBlack == 0) //black
                {
                    lbIPBlackList.Items.Add(filter.IPAddr);
                }
                else
                {
                    lbIPWhiteList.Items.Add(filter.IPAddr);
                }
            }

        }

        private void AddButton_Click(object sender, EventArgs e)
        {
            //MessageBox.Show(tabControl1.SelectedTab.Name);
            if (tabControl1.SelectedTab.Name == "tabPage1")
            {
                IPAddress ipAddress;
                if (IPAddress.TryParse(mtbIPAddr.Text, out ipAddress))
                {
                    //valid ip
                    IPFilter filter = new IPFilter();
                    filter.WhiteOrBlack = 0; //black
                    filter.FilterType = 0; //ip address
                    filter.IPAddr = mtbIPAddr.Text;
                    filter.DBIdx = pbx.getSecurityFilterMaxID();

                    if (SIPPBXCFGDB.AddSecurityToDB(filter, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        pbx.IPFilterList.Add(filter);

                        lbIPBlackList.Items.Add(mtbIPAddr.Text);
                        lbIPBlackList.SelectedIndex = lbIPBlackList.Items.Count - 1;
                    }
                    else
                    {
                        MessageBox.Show("Cannot add this IP address into DB.", "Error");
                    }
                }
                else
                {
                    //is not valid ip
                    MessageBox.Show("Not a valid IP address!", "Error");
                }
            }
            else if (tabControl1.SelectedTab.Name == "tabPage2")
            {
                IPAddress ipAddress;
                if (IPAddress.TryParse(mtbIPAddr.Text, out ipAddress))
                {
                    //valid ip
                    IPFilter filter = new IPFilter();
                    filter.WhiteOrBlack = 1; //white
                    filter.FilterType = 0; //ip address
                    filter.IPAddr = mtbIPAddr.Text;
                    filter.DBIdx = pbx.getSecurityFilterMaxID();

                    if (SIPPBXCFGDB.AddSecurityToDB(filter, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        pbx.IPFilterList.Add(filter);

                        lbIPWhiteList.Items.Add(mtbIPAddr.Text);
                        lbIPWhiteList.SelectedIndex = lbIPWhiteList.Items.Count - 1;
                    }
                    else
                    {
                        MessageBox.Show("Cannot add this IP address into DB.", "Error");
                    }
                }
                else
                {
                    //is not valid ip
                    MessageBox.Show("Not a valid IP address!", "Error");
                }
            }
        }

        private void DeleteButton_Click(object sender, EventArgs e)
        {
            if (tabControl1.SelectedTab.Name == "tabPage1")
            {
                if (lbIPBlackList.SelectedIndex < 0)
                {
                    MessageBox.Show("No selection in the list", "Error");
                    return;
                }

                IPFilter filter = null;
                for (int i = 0; i < pbx.IPFilterList.Count; i++)
                {
                    if (pbx.IPFilterList[i].IPAddr == lbIPBlackList.SelectedItem.ToString() && pbx.IPFilterList[i].WhiteOrBlack == 0)
                    {
                        filter = pbx.IPFilterList[i];
                    }
                }

                if (filter != null)
                {
                    if (SIPPBXCFGDB.RemoveSecurityFromDB(filter, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        pbx.IPFilterList.Remove(filter);

                        lbIPBlackList.Items.Remove(lbIPBlackList.SelectedItem);
                    }
                    else
                    {
                        MessageBox.Show("Cannot remove this IP address from DB.", "Error");
                    }
                }
                else
                {
                    lbIPBlackList.Items.Remove(lbIPBlackList.SelectedItem);
                }

            }
            else if (tabControl1.SelectedTab.Name == "tabPage2")
            {
                if (lbIPWhiteList.SelectedIndex < 0)
                {
                    MessageBox.Show("No selection in the list", "Error");
                    return;
                }

                IPFilter filter = null;
                for (int i = 0; i < pbx.IPFilterList.Count; i++)
                {
                    if (pbx.IPFilterList[i].IPAddr == lbIPWhiteList.SelectedItem.ToString() && pbx.IPFilterList[i].WhiteOrBlack == 1)
                    {
                        filter = pbx.IPFilterList[i];
                    }
                }

                if (filter != null)
                {
                    if (SIPPBXCFGDB.RemoveSecurityFromDB(filter, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        pbx.IPFilterList.Remove(filter);

                        lbIPWhiteList.Items.Remove(lbIPWhiteList.SelectedItem);
                    }
                    else
                    {
                        MessageBox.Show("Cannot remove this IP address from DB.", "Error");
                    }
                }
                else
                {
                    lbIPWhiteList.Items.Remove(lbIPWhiteList.SelectedItem);
                }

            }
        }

        private void OkButton_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
