using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SIPNetSet : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public SIPNetSet()
        {
            InitializeComponent();
        }

        private void SIPNetSet_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < GTAPIASM.GTAPIEnv.GetLocalIPCount(); i++)
            {
                cbSIPAddr.Items.Add(GTAPIASM.GTAPIEnv.GetLocalIP(i));
            }
            cbSIPAddr.Text = pbx.sip_set.sipAddr;
            textSIPPort.Text = pbx.sip_set.sipPort.ToString();
            textRTPPort.Text = pbx.sip_set.rtpPort.ToString();
            textRTPPortSpace.Text = pbx.sip_set.rtpPortSpace.ToString();
            textInternalPort.Text = pbx.sip_set.internalPort.ToString();
            textAudoCodecs.Text = pbx.sip_set.auCodecs;
            textVideoCodecs.Text = pbx.sip_set.videoCodecs;
            tbStunServer.Text = pbx.sip_set.sStunServer;
            tbManagerPort.Text = pbx.sip_set.managerPort.ToString();
            cbMapRTP.Checked = (pbx.sip_set.dynMapRTP == 1) ? true : false;
            cbRTPRelay.Checked = pbx.sip_set.doRTPRelay;

            cbDTMFMethod.Items.Add("Inband Audio");
            cbDTMFMethod.Items.Add("SIP INFO");
            cbDTMFMethod.Items.Add("RFC 2833(RTP)");
            cbDTMFMethod.Items.Add("Auto(Inband Audio or RFC 2833)");
            cbDTMFMethod.SelectedIndex = pbx.sip_set.dtmfMethod;
            tbPublicIP.Text = pbx.sip_set.sPublicIPAddr;

            textEmailServer.Text = pbx.email_set.emailServer;
            textEmailSrvPort.Text = pbx.email_set.emailPort.ToString();
            textEmailAddr.Text = pbx.email_set.emailAddr;
            textEmailPassword.Text = pbx.email_set.emailPassword;
            cbEmailEnableSSL.Checked = pbx.email_set.emailSSL;

            cbUseDNSSrv.Checked = pbx.sip_set.useDNSSRV;

            cbProxyExten.Checked = pbx.sip_set.doExtenProxy;

            cbForwardPAssertedIdentity.Checked = pbx.sip_set.bForwardPAssertedIdentity;

            if (pbx.sip_set.sipProtocol == 1)
            {
                cbSIPProtUDP.Checked = true;
                cbSIPProtTCP.Checked = false;
            }
            else if (pbx.sip_set.sipProtocol == 2)
            {
                cbSIPProtUDP.Checked = false;
                cbSIPProtTCP.Checked = true;
            }
            else if (pbx.sip_set.sipProtocol == 3)
            {
                cbSIPProtUDP.Checked = true;
                cbSIPProtTCP.Checked = true;
            }
            else
            {
                cbSIPProtUDP.Checked = true;
                cbSIPProtTCP.Checked = false;
            }
        }

        private void BtnOK_Click(object sender, EventArgs e)
        {
            bool bInList = false;
            if (cbSIPAddr.Text.Length > 0)
            {
                for (int i = 0; i < GTAPIASM.GTAPIEnv.GetLocalIPCount(); i++)
                {
                    if (GTAPIASM.GTAPIEnv.GetLocalIP(i) == cbSIPAddr.Text)
                    {
                        bInList = true;
                        break;
                    }
                }
            }
            else
            {
                bInList = true;
            }
            if (!bInList)
            {
                MessageBox.Show("Specified IP address(" + cbSIPAddr.Text + ") is not a valid local IP address");
                return;
            }

            if (textSIPPort.Text.Length == 0 || textRTPPort.Text.Length == 0)
            {
                MessageBox.Show("Wrong Data! Please re-input!");
                return;
            }

            try
            {
                pbx.sip_set.sipAddr = cbSIPAddr.Text;
                pbx.sip_set.sipPort = Convert.ToUInt16(textSIPPort.Text);
                pbx.sip_set.rtpPort = Convert.ToUInt16(textRTPPort.Text);
                pbx.sip_set.rtpPortSpace  = Convert.ToUInt16(textRTPPortSpace.Text);
                pbx.sip_set.internalPort = Convert.ToUInt16(textInternalPort.Text);
                pbx.sip_set.auCodecs = textAudoCodecs.Text.Trim();
                pbx.sip_set.videoCodecs = textVideoCodecs.Text.Trim();
                pbx.sip_set.sStunServer = tbStunServer.Text;
                pbx.sip_set.dtmfMethod = cbDTMFMethod.SelectedIndex;
                pbx.sip_set.sPublicIPAddr = tbPublicIP.Text;
                pbx.sip_set.managerPort = Convert.ToUInt16(tbManagerPort.Text);

                pbx.email_set.emailServer = textEmailServer.Text;
                if(textEmailSrvPort.Text.Length > 0)
                    pbx.email_set.emailPort = Convert.ToUInt16(textEmailSrvPort.Text);
                pbx.email_set.emailAddr = textEmailAddr.Text;
                pbx.email_set.emailPassword = textEmailPassword.Text;
                pbx.email_set.emailSSL = cbEmailEnableSSL.Checked;
                pbx.sip_set.dynMapRTP = Convert.ToUInt16(cbMapRTP.Checked ? 1 : 0);
                pbx.sip_set.doRTPRelay = cbRTPRelay.Checked;
                pbx.sip_set.useDNSSRV = cbUseDNSSrv.Checked;
                pbx.sip_set.doExtenProxy = cbProxyExten.Checked;
                pbx.sip_set.bForwardPAssertedIdentity = cbForwardPAssertedIdentity.Checked;

                pbx.sip_set.sipProtocol = 0;
                if (cbSIPProtUDP.Checked) pbx.sip_set.sipProtocol += 1;
                if (cbSIPProtTCP.Checked) pbx.sip_set.sipProtocol += 2;
                if (pbx.sip_set.sipProtocol == 0) pbx.sip_set.sipProtocol = 1;
            }
            catch (Exception ex)
            {
                main_form.LogoutText(ex.ToString());
                MessageBox.Show(ex.ToString());
                return;
            }

            DialogResult = DialogResult.OK;

            Close();

            //MessageBox.Show("You need to restart this PBX to make the change effective!", "Error");
        }

        private void BtnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
            //main_form.SaveSIPNetConfigToRegistry();
        }

        private void cbSIPProtUDP_CheckedChanged(object sender, EventArgs e)
        {
            if (!cbSIPProtUDP.Checked && !cbSIPProtTCP.Checked)
            {
                MessageBox.Show("At least one of protocols should be checked!", "Error");
                cbSIPProtUDP.Checked = true;
            }
        }

        private void cbSIPProtTCP_CheckedChanged(object sender, EventArgs e)
        {
            if (!cbSIPProtUDP.Checked && !cbSIPProtTCP.Checked)
            {
                MessageBox.Show("At least one of protocols should be checked!", "Error");
                cbSIPProtTCP.Checked = true;
            }
        }
    }
}