using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SIPAccEdit : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public SIPAccEdit()
        {
            InitializeComponent();
        }

        private void OKBtn_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void SIPAccEdit_Load(object sender, EventArgs e)
        {
            // Create columns for the items and subitems.
            SIPAccList.Columns.Add("Display Name", 120, HorizontalAlignment.Left);
            SIPAccList.Columns.Add("User Name", 120, HorizontalAlignment.Left);
            SIPAccList.Columns.Add("Domain", 120, HorizontalAlignment.Left);
            SIPAccList.Columns.Add("Proxy", 120, HorizontalAlignment.Left);

            if (main_form.SelfBrand.Length > 0)
                linkLabel1.Visible = false;

            ShowSIPAccounts();
        }

        public void ShowSIPAccounts()
        {
            SIPAccList.Items.Clear();

            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_acct[i].DisplayName);
                aItem.SubItems.Add(pbx.sip_acct[i].UserName);
                aItem.SubItems.Add(pbx.sip_acct[i].DomainServer);
                aItem.SubItems.Add(pbx.sip_acct[i].ProxyServer);
                SIPAccList.Items.Add(aItem);
            }
        }

        private void AddBtn_Click(object sender, EventArgs e)
        {
            SIPAccAdd dlg = new SIPAccAdd();
            dlg.pbx = pbx;
            dlg.parent_dlg = this;
            dlg.ShowDialog();
        }

        private void EditBtn_Click(object sender, EventArgs e)
        {
            if (SIPAccList.SelectedIndices.Count > 0)
            {
                SIPAccAdd dlg = new SIPAccAdd();
                dlg.Text = "Edit SIP Account";
                dlg.pbx = pbx;
                dlg.parent_dlg = this;
                dlg.idx = SIPAccList.SelectedIndices[0];
                dlg.ShowDialog();
            }
            else
            {
                MessageBox.Show("Please select a SIP account first!", "Error");
            }
        }

        private void DeteteBtn_Click(object sender, EventArgs e)
        {
            if (SIPAccList.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveSIPAccountFromDB(pbx.sip_acct[SIPAccList.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.sip_acct.RemoveAt(SIPAccList.SelectedIndices[0]);
                    SIPAccList.Items.RemoveAt(SIPAccList.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Cannot delete this SIP account from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select a SIP account first!", "Error");
            }
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.pcbest.net/tested-itsps.php");
        }


    }
}