using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SIPAccAdd : Form
    {
        public int idx;
        public SIPPBX pbx;
        public SIPAccEdit parent_dlg;

        public SIPAccAdd()
        {
            InitializeComponent();
            idx = -1;
        }

        private void BtnOK_Click(object sender, EventArgs e)
        {
            SIPAccount acct;
            if (idx >= 0)
            {
                acct = pbx.sip_acct[idx];
                acct.DisplayName = textDisplayName.Text;
                acct.UserName = textUserName.Text;
                acct.DomainServer = textSIPDomain.Text;
                acct.ProxyServer = textSIPProxy.Text;
                acct.AuthName = textAuth.Text;
                acct.Password = textPassword.Text;
                acct.ExpireSec = Convert.ToInt32(textExpire.Text);
                acct.RegWithProxyServer = checkRegisterSIPProxy.Checked;
                if (cbMapExten.Checked)
                {
                    acct.MappedExten = cbMappedExten.Text;
                }
                else
                    acct.MappedExten = "";

                acct.SIPProtocol = rbSIPUDP.Checked ? 0 : 1;
                acct.SIPTrunk = cbSIPTrunk.Checked ? 1 : 0;
            }
            else
            {
                acct = new SIPAccount();
                acct.DisplayName = textDisplayName.Text;
                acct.UserName = textUserName.Text;
                acct.DomainServer = textSIPDomain.Text;
                acct.ProxyServer = textSIPProxy.Text;
                acct.AuthName = textAuth.Text;
                acct.Password = textPassword.Text;
                acct.RegWithProxyServer = checkRegisterSIPProxy.Checked;
                acct.ExpireSec = Convert.ToInt32(textExpire.Text);
                acct.AccID = pbx.getNextSIPAccountID();
                if (cbMapExten.Checked)
                {
                    acct.MappedExten = cbMappedExten.Text;
                }
                else
                    acct.MappedExten = "";

                acct.SIPProtocol = rbSIPUDP.Checked? 0 : 1;
                acct.SIPTrunk = cbSIPTrunk.Checked? 1 : 0;
                pbx.sip_acct.Add(acct);
            }

            acct.DIDList.Clear();
            for (int i = 0; i < lbDIDs.Items.Count; i++)
            {
                acct.DIDList.Add((string)lbDIDs.Items[i]);
            }

            acct.OutboundAcceptOtherID = cbAcceptOtherID.Checked;
            acct.OutboundAppendExtenID = cbOutboundAppendExtenID.Checked;
            acct.UseLocalIPInFrom = cbUseLocalIPInFrom.Checked;


            //if close the form before retriving its sub-window-items values, those values will be null.
            Close();

            if (idx >= 0)
            {
                if (!SIPPBXCFGDB.UpdateSIPAccountInDB(acct, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    MessageBox.Show("SIP Account cannot be updated to DB!", "Error");
                }
            }
            else
            {
                if (!SIPPBXCFGDB.AddSIPAccountToDB(acct, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    MessageBox.Show("SIP Account cannot be added to DB!", "Error");
                    pbx.sip_acct.Remove(acct);
                }
            }

            parent_dlg.ShowSIPAccounts();
        }

        private void SIPAccAdd_Load(object sender, EventArgs e)
        {
            SIPAccount acct;
            if (idx >= 0)
            {
                acct = pbx.sip_acct[idx];

                textDisplayName.Text = acct.DisplayName;
                textUserName.Text = acct.UserName;

                if (parent_dlg.main_form.SelfBrand.Contains("iFoneline"))
                {
                    textSIPDomain.Text = "sip.ifoneline.com";
                    textSIPDomain.Enabled = false;
                    textSIPProxy.Text = "sip.ifoneline.com";
                    textSIPProxy.Enabled = false;
                }
                else if (parent_dlg.main_form.SelfBrand.Contains("ENACCS"))
                {
                    textSIPDomain.Text = "sip.enaccs.com";
                    textSIPDomain.Enabled = false;
                    textSIPProxy.Text = "sip.enaccs.com";
                    textSIPProxy.Enabled = false;
                }
                else
                {
                    textSIPDomain.Text = acct.DomainServer;
                    textSIPProxy.Text = acct.ProxyServer;
                }

                textAuth.Text = acct.AuthName;
                textPassword.Text = acct.Password;
                textExpire.Text = acct.ExpireSec.ToString();
                checkRegisterSIPProxy.Checked = acct.RegWithProxyServer;

                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    lbDIDs.Items.Add(acct.DIDList[i]);
                }

                cbAcceptOtherID.Checked = acct.OutboundAcceptOtherID;
                if (cbAcceptOtherID.Checked)
                    cbOutboundAppendExtenID.Enabled = true;
                else
                    cbOutboundAppendExtenID.Enabled = false;

                cbOutboundAppendExtenID.Checked = acct.OutboundAppendExtenID;


                cbUseLocalIPInFrom.Checked = acct.UseLocalIPInFrom;

                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    cbMappedExten.Items.Add(pbx.sip_exten[i].UserName);
                }
                if(cbMappedExten.Items.Count > 0)
                    cbMappedExten.SelectedIndex = 0;

                if (acct.MappedExten.Length > 0)
                {
                    cbMapExten.Checked = true;
                    cbMappedExten.Text = acct.MappedExten;
                }
                else
                {
                    cbMapExten.Checked = false;
                    cbMappedExten.Enabled = false;
                }

                if (acct.SIPProtocol == 0)
                {
                    rbSIPUDP.Checked = true;
                    rbSIPTCP.Checked = false;
                }
                else
                {
                    rbSIPUDP.Checked = false;
                    rbSIPTCP.Checked = true;
                }

                if (acct.SIPTrunk == 1)
                {
                    textAuth.Enabled = false;
                    textPassword.Enabled = false;
                    textExpire.Enabled = false;
                    checkRegisterSIPProxy.Enabled = false;
                    checkRegisterSIPProxy.Checked = false;
                }

            }
            else
            {
                textExpire.Text = "3600";
                checkRegisterSIPProxy.Checked = true;

                if (parent_dlg.main_form.SelfBrand.Contains("iFoneline"))
                {
                    textSIPDomain.Text = "sip.ifoneline.com";
                    textSIPDomain.Enabled = false;
                    textSIPProxy.Text = "sip.ifoneline.com";
                    textSIPProxy.Enabled = false;
                }
                else if (parent_dlg.main_form.SelfBrand.Contains("ENACCS"))
                {
                    textSIPDomain.Text = "sip.enaccs.com";
                    textSIPDomain.Enabled = false;
                    textSIPProxy.Text = "sip.enaccs.com";
                    textSIPProxy.Enabled = false;
                }

                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    cbMappedExten.Items.Add(pbx.sip_exten[i].UserName);
                }

                if (cbMappedExten.Items.Count > 0)
                    cbMappedExten.SelectedIndex = 0;

                cbMapExten.Checked = false;
                cbMappedExten.Enabled = false;

                rbSIPUDP.Checked = true;
                rbSIPTCP.Checked = false;
            }
        }

        private void BtnCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnAddDID_Click(object sender, EventArgs e)
        {
            if(tbDIDNum.Text.Trim().Length > 0)
                lbDIDs.Items.Add(tbDIDNum.Text);
        }

        private void btnRemoveDID_Click(object sender, EventArgs e)
        {
            if (lbDIDs.SelectedIndex >= 0)
            {
                lbDIDs.Items.RemoveAt(lbDIDs.SelectedIndex);
            }
            else
            {
                MessageBox.Show("Please select one item first to remove!");
            }
        }

        private void cbMapExten_CheckedChanged(object sender, EventArgs e)
        {
            if (cbMapExten.Checked)
            {
                cbMappedExten.Enabled = true;
            }
            else
            {
                cbMappedExten.Enabled = false;
            }
        }

        private void cbAcceptOtherID_CheckedChanged(object sender, EventArgs e)
        {
            if (cbAcceptOtherID.Checked)
                cbOutboundAppendExtenID.Enabled = true;
            else
                cbOutboundAppendExtenID.Enabled = false;

        }

        private void cbSIPTrunk_CheckedChanged(object sender, EventArgs e)
        {
            if (cbSIPTrunk.Checked)
            {
                textAuth.Enabled = false;
                textPassword.Enabled = false;
                textExpire.Enabled = false;
                checkRegisterSIPProxy.Enabled = false;
                checkRegisterSIPProxy.Checked = false;
            }
            else
            {
                textAuth.Enabled = true;
                textPassword.Enabled = true;
                textExpire.Enabled = true;
                checkRegisterSIPProxy.Enabled = true;
            }
        }
        /*
        private void rbSIPUDP_CheckedChanged(object sender, EventArgs e)
        {
            if (rbSIPUDP.Checked)
                rbSIPTCP.Checked = false;
            else
                rbSIPTCP.Checked = true;
        }

        private void rbSIPTCP_CheckedChanged(object sender, EventArgs e)
        {
            if (rbSIPTCP.Checked)
                rbSIPUDP.Checked = false;
            else
                rbSIPUDP.Checked = true;
        }*/



    }
}