using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class PickupGroupEdit : Form
    {
        public PickUpGroup pk_group;
        public SIPPBX pbx;

        public PickupGroupEdit()
        {
            InitializeComponent();
        }

        private void PickupGroupEdit_Load(object sender, EventArgs e)
        {
            cbMembertype.Items.Add("Extension");
            cbMembertype.Items.Add("Agent");
            cbMembertype.SelectedIndex = pk_group.ml.mb_type;

            tbGroupName.Text = pk_group.name;

            if (pk_group.name.Length > 0)
            {
                //in editing, shouldn't allow to change the name
                tbGroupName.Enabled = false;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (tbGroupName.Text.Trim().Length == 0)
            {
                MessageBox.Show("Pickup group must have a unique name");
                return;
            }

            pk_group.name = tbGroupName.Text;
            pk_group.ml.mb_type = cbMembertype.SelectedIndex;
            pk_group.ml.members.Clear();
            for(int i=0; i<clbMembers.CheckedItems.Count; i++)
            {
                pk_group.ml.members.Add((string)clbMembers.CheckedItems[i]);
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void cbMembertype_SelectedIndexChanged(object sender, EventArgs e)
        {
            clbMembers.Items.Clear();

            if (cbMembertype.SelectedIndex == 0)
            {
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    string extn = pbx.sip_exten[i].UserName;
                    bool found = false;
                    for (int j = 0; j < pk_group.ml.members.Count; j++)
                    {
                        if (pk_group.ml.members[j] == extn)
                        {
                            found = true;
                            break;
                        }
                    }
                    clbMembers.Items.Add(extn, found);
                }
            }
            else
            {
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                {
                    string agent = pbx.sip_agents[i].Code;
                    bool found = false;
                    for (int j = 0; j < pk_group.ml.members.Count; j++)
                    {
                        if (pk_group.ml.members[j] == agent)
                        {
                            found = true;
                            break;
                        }
                    }
                    clbMembers.Items.Add(agent, found);
                }
            }
           
        }
    }
}