using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class DialPlanStep1 : Form
    {
        public SIPPBX pbx;
        public SIPPBXDialPlan dp;
        public DialPlanList dplist;

        public DialPlanStep1()
        {
            InitializeComponent();
        }

        private void DialPlanStep1_Load(object sender, EventArgs e)
        {
            tbPlanName.Text = dp.planName;
            if (dp.planName.Length > 0)
            {
                tbPlanName.Enabled = false;
            }

            if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
            {
                rbInbound.Checked = true;
                rbOutbound.Checked = false;
            }
            else
            {
                rbInbound.Checked = false;
                rbOutbound.Checked = true;
            }

            int idx = -1;
            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                cbCalledNumber.Items.Add(pbx.sip_acct[i].UserName);
                if (pbx.sip_acct[i].UserName == dp.CalledID)
                    idx = i;
            }

            if (idx >= 0)
            {
                cbCalledNumber.SelectedIndex = idx;
            }
            else
            {
                if (dp.CalledID.Length > 0)
                {
                    cbCalledNumber.Items.Add(dp.CalledID);
                    cbCalledNumber.SelectedText = dp.CalledID;
                }
            }

            idx = -1;
            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                cbCallerNumber.Items.Add(pbx.sip_exten[i].UserName);
                if (pbx.sip_exten[i].UserName == dp.CallerID)
                    idx = i;
            }

            if (idx >= 0)
            {
                cbCallerNumber.SelectedIndex = idx;
            }
            else
            {
                if (dp.CallerID.Length > 0)
                {
                    cbCallerNumber.Items.Add(dp.CallerID);
                    cbCallerNumber.SelectedText = dp.CallerID;
                }
            }

            ResponseToCallDirectionChanged();


            //time schedule
            if (dp.TimeLimited)
            {
                cbTimeSchedule.Checked = true;
                tbTime1.Enabled = true;
                tbTime2.Enabled = true;
                cbMonday.Enabled = true;
                cbTuesday.Enabled = true;
                cbWednesday.Enabled = true;
                cbThursday.Enabled = true;
                cbFriday.Enabled = true;
                cbSaturday.Enabled = true;
                cbSunday.Enabled = true;

                tbTime1.Text = dp.TimeStartHour.ToString() + ":" + dp.TimeStartMinute.ToString();
                tbTime2.Text = dp.TimeEndHour.ToString() + ":" + dp.TimeEndMinute.ToString();

                for (int i = 0; i < 7; i++)
                {
                    bool bChecked = false;
                    if (dp.TimeDays[i] == 1)
                        bChecked = true;

                    switch (i)
                    {
                        case 0:
                            cbMonday.Checked = bChecked;
                            break;
                        case 1:
                            cbTuesday.Checked = bChecked;
                            break;
                        case 2:
                            cbWednesday.Checked = bChecked;
                            break;
                        case 3:
                            cbThursday.Checked = bChecked;
                            break;
                        case 4:
                            cbFriday.Checked = bChecked;
                            break;
                        case 5:
                            cbSaturday.Checked = bChecked;
                            break;
                        case 6:
                            cbSunday.Checked = bChecked;
                            break;
                    }
                }
            }
            else
            {
                cbTimeSchedule.Checked = false;
                tbTime1.Enabled = false;
                tbTime2.Enabled = false;
                cbMonday.Enabled = false;
                cbTuesday.Enabled = false;
                cbWednesday.Enabled = false;
                cbThursday.Enabled = false;
                cbFriday.Enabled = false;
                cbSaturday.Enabled = false;
                cbSunday.Enabled = false;
            }
        }

        private void btnNext_Click(object sender, EventArgs e)
        {
            if (tbPlanName.Text.Trim().Length == 0)
            {
                MessageBox.Show("You must give an unique plan name!", "Error");
                return;
            }

            dp.planName = tbPlanName.Text;
            if (rbInbound.Checked)
                dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
            else
                dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;

            dp.CalledID = cbCalledNumber.Text;
            dp.CallerID = cbCallerNumber.Text;

            if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
            {
                switch (cbTemplete.SelectedIndex)
                {
                    case 0:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 1:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 2:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 3:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 4:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB;
                        break;
                    case 5:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 6:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 7:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 8:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 9:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 10:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                    case 11:
                        dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST;
                        dp.DestAddress = cbDestAddr.Text;
                        break;
                }
                dp.MemberList = null;
            }
            else
            {
                dp.OutboundPreStrip = tbOutboundStrip.Text;
                dp.OutboundPrepend = tbPrepend.Text;
                dp.OutboundSIPAcct = cbOutboundSIPAcct.SelectedIndex;
                dp.OutboundSIPAcct1 = cbOutboundSIPAcct1.SelectedIndex;
                if (rbAllExtensions.Checked)
                    dp.MemberList = null;
            }

            if (cbTimeSchedule.Checked)
            {
                dp.TimeLimited = true;
                if (cbMonday.Checked)
                    dp.TimeDays[0] = 1;
                else
                    dp.TimeDays[0] = 0;

                if (cbTuesday.Checked)
                    dp.TimeDays[1] = 1;
                else
                    dp.TimeDays[1] = 0;

                if (cbWednesday.Checked)
                    dp.TimeDays[2] = 1;
                else
                    dp.TimeDays[2] = 0;

                if (cbThursday.Checked)
                    dp.TimeDays[3] = 1;
                else
                    dp.TimeDays[3] = 0;

                if (cbFriday.Checked)
                    dp.TimeDays[4] = 1;
                else
                    dp.TimeDays[4] = 0;

                if (cbSaturday.Checked)
                    dp.TimeDays[5] = 1;
                else
                    dp.TimeDays[5] = 0;

                if (cbSunday.Checked)
                    dp.TimeDays[6] = 1;
                else
                    dp.TimeDays[6] = 0;

                string s = tbTime1.Text;
                if (s.Contains(":"))
                {
                    int pos = s.IndexOf(':');
                    dp.TimeStartHour = Convert.ToInt32(s.Substring(0, pos));
                    dp.TimeStartMinute = Convert.ToInt32(s.Substring(pos+1));
                }
                else
                {
                    dp.TimeStartHour = Convert.ToInt32(s);
                    dp.TimeStartMinute = 0;
                }

                s = tbTime2.Text;
                if (s.Contains(":"))
                {
                    int pos = s.IndexOf(':');
                    dp.TimeEndHour = Convert.ToInt32(s.Substring(0, pos));
                    dp.TimeEndMinute = Convert.ToInt32(s.Substring(pos + 1));
                }
                else
                {
                    dp.TimeEndHour = Convert.ToInt32(s);
                    dp.TimeEndMinute = 0;
                }
            }
            else
            {
                dp.TimeLimited = false;
            }

            DialogResult = DialogResult.OK;

            Close();

/*
            if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
            {
                if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                {
                    DialPlanAutoAttendForm auto_att_dlg = new DialPlanAutoAttendForm();
                    auto_att_dlg.dp = dp;
                    auto_att_dlg.pbx = pbx;
                    //auto_att_dlg.dplist = dplist;
                    if(auto_att_dlg.ShowDialog() == DialogResult.OK)
                        dplist.ShowDialPlanList();
                }
                else
                {
                    if (!pbx.sip_dialplan.Contains(dp))
                        pbx.sip_dialplan.Add(dp);
                    dplist.ShowDialPlanList();
                }
            }
            else
            {
                //outbound plan only have one step;
                if (!pbx.sip_dialplan.Contains(dp))
                    pbx.sip_dialplan.Add(dp);
                dplist.ShowDialPlanList();
            }
  */
        }

        private void ResponseToCallDirectionChanged()
        {
            if (rbInbound.Checked)
            {
                cbTemplete.Enabled = true;
                cbTemplete.Items.Clear();
                cbTemplete.Items.Add("Auto Attendant(IVR Menu)");
                cbTemplete.Items.Add("Voice Mail Box");
                cbTemplete.Items.Add("Automatic Call Distribution(ACD)");
                cbTemplete.Items.Add("Dial Extension");
                cbTemplete.Items.Add("Do Not Disturb");
                cbTemplete.Items.Add("Monitor group");
                cbTemplete.Items.Add("Ring Group");
                cbTemplete.Items.Add("Conference");
                cbTemplete.Items.Add("Run Plugin");
                cbTemplete.Items.Add("Call Forward");
                cbTemplete.Items.Add("Music Server");
                cbTemplete.Items.Add("Echo Test");

                tbOutboundStrip.Enabled = false;
                tbPrepend.Enabled = false;
                cbOutboundSIPAcct.Enabled = false;
                cbOutboundSIPAcct1.Enabled = false;
                cbDestAddr.Enabled = true;

                switch (dp.CallPlan)
                {
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT:
                        cbTemplete.SelectedIndex = 0;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX:
                        cbTemplete.SelectedIndex = 1;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE:
                        cbTemplete.SelectedIndex = 2;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION:
                        cbTemplete.SelectedIndex = 3;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB:
                        cbTemplete.SelectedIndex = 4;
                        btnOK.Text = "Finish";
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP:
                        cbTemplete.SelectedIndex = 5;
                        btnOK.Text = "Finish";
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP:
                        cbTemplete.SelectedIndex = 6;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM:
                        cbTemplete.SelectedIndex = 7;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE:
                        cbTemplete.SelectedIndex = 8;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING:
                        cbTemplete.SelectedIndex = 9;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER:
                        cbTemplete.SelectedIndex = 10;
                        btnOK.Text = "Finish";
                        cbDestAddr.Text = pbx.moh_dir; //dp.DestAddress;
                        break;
                    case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST:
                        cbTemplete.SelectedIndex = 11;
                        btnOK.Text = "Finish";
                        cbDestAddr.Enabled = false;
                        break;
                }

                rbAllExtensions.Enabled = false;
                rbSelectedExtensions.Enabled = false;
                btnSetExtensions.Enabled = false;

            }
            else
            {
                cbTemplete.Enabled = false;

                tbOutboundStrip.Enabled = true;
                tbPrepend.Enabled = true;
                cbOutboundSIPAcct.Enabled = true;
                cbOutboundSIPAcct1.Enabled = true;
                cbDestAddr.Enabled = false;

                tbOutboundStrip.Text = dp.OutboundPreStrip;
                tbPrepend.Text = dp.OutboundPrepend;

                cbOutboundSIPAcct.Items.Clear();
                cbOutboundSIPAcct1.Items.Clear();
                if (pbx.sip_acct.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_acct.Count; i++)
                    {
                        cbOutboundSIPAcct.Items.Add(pbx.sip_acct[i].DisplayName + " " + pbx.sip_acct[i].UserName);
                        cbOutboundSIPAcct1.Items.Add(pbx.sip_acct[i].DisplayName + " " + pbx.sip_acct[i].UserName);
                    }

                    if (dp.OutboundSIPAcct >= 0 && dp.OutboundSIPAcct < pbx.sip_acct.Count)
                    {
                        cbOutboundSIPAcct.SelectedIndex = dp.OutboundSIPAcct;
                    }
                    else
                    {
                        cbOutboundSIPAcct.SelectedIndex = 0;
                        dp.OutboundSIPAcct = 0;
                    }

                    if (dp.OutboundSIPAcct1 >= 0 && dp.OutboundSIPAcct1 < pbx.sip_acct.Count)
                    {
                        cbOutboundSIPAcct1.SelectedIndex = dp.OutboundSIPAcct1;
                    }
                    else
                    {
                        cbOutboundSIPAcct1.SelectedIndex = 0;
                        dp.OutboundSIPAcct1 = 0;
                    }

                }
                else
                {
                    cbOutboundSIPAcct.Enabled = false;
                    cbOutboundSIPAcct1.Enabled = false;
                }

                btnOK.Text = "OK";

                rbAllExtensions.Enabled = true;
                rbSelectedExtensions.Enabled = true;

                if (dp.MemberList == null)
                {
                    rbAllExtensions.Checked = true;
                    rbSelectedExtensions.Checked = false;
                    btnSetExtensions.Enabled = false;
                }
                else
                {
                    rbAllExtensions.Checked = false;
                    rbSelectedExtensions.Checked = true;
                    btnSetExtensions.Enabled = true;
                }

            }

        }

        private void rbOutbound_CheckedChanged(object sender, EventArgs e)
        {
            ResponseToCallDirectionChanged();
        }

        private void rbInbound_CheckedChanged(object sender, EventArgs e)
        {
            ResponseToCallDirectionChanged();
        }

        private void cbTemplete_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cbTemplete.SelectedIndex == 0) //AUTO_ATTENDANT
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_ivrs.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_ivrs.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_ivrs[i].name);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 1) //VOICE_MAIL_BOX
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_exten.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_exten.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_exten[i].UserName);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 2) //ACD_QUEUE
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_huntgroups.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_huntgroups[i].hgName);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any hunt group yet! Please add a hunt group first.", "Warning");
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 3) //DIAL_EXTENSION
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_exten.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_exten.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_exten[i].UserName);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any extension yet! Please add an extension first.", "Warning");
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 4) //DO_NOT_DISTURB
            {
                cbDestAddr.Enabled = false;
                cbDestAddr.Items.Clear();
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 5) //Monitor Group
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_monitorgroups.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_monitorgroups.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_monitorgroups[i].mgName);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any monitor group yet! Please add a monitor group first.", "Warning");
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 6) //Ring Group
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_ringgroups.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_ringgroups[i].gpName);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any ring group yet! Please add a ring group first.", "Warning");
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 7) //conference room
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.sip_conferooms.Count > 0)
                {
                    for (int i = 0; i < pbx.sip_conferooms.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.sip_conferooms[i].conf_name);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any conference room yet! Please add a conference room first.", "Warning");
                    cbDestAddr.Enabled = false;
                }
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 8) //Plugin
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();

                SIPPBXDBUtil.AddPluginsIntoComboBox(pbx, cbDestAddr, "", pbx.db_set.myConn, PBXMainForm.log);

                /*
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                if (pbx.plugins.Count > 0)
                {
                    for (int i = 0; i < pbx.plugins.Count; i++)
                    {
                        cbDestAddr.Items.Add(pbx.plugins[i].Name);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any plugin yet! Please add a plugin dll first.", "Warning");
                    cbDestAddr.Enabled = false;
                }
                */
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 9) //CALL_FORWARDING
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();

                int cntOutDP = 0;
                for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                {
                    if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        cntOutDP++;
                    }
                }

                if (cntOutDP > 0)
                {
                    for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                    {
                        if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                            cbDestAddr.Items.Add(pbx.sip_dialplan[i].planName);
                    }
                    cbDestAddr.SelectedIndex = 0;
                }
                else
                {
                    MessageBox.Show("There isn't any dialplan yet! Please add an outbound dialplan first.", "Warning");
                    cbDestAddr.Enabled = false;
                }

                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 10) //MUSIC_SERVER
            {
                cbDestAddr.Enabled = true;
                cbDestAddr.Items.Clear();
                cbDestAddr.Text = pbx.moh_dir;
                btnOK.Text = "Finish";
            }
            else if (cbTemplete.SelectedIndex == 11) //ECHO_TEST
            {
                cbDestAddr.Enabled = false;
                cbDestAddr.Items.Clear();
                btnOK.Text = "Finish";
            }
        }

        private void cbTimeSchedule_CheckedChanged(object sender, EventArgs e)
        {
            if (cbTimeSchedule.Checked)
            {
                tbTime1.Enabled = true;
                tbTime2.Enabled = true;
                cbMonday.Enabled = true;
                cbTuesday.Enabled = true;
                cbWednesday.Enabled = true;
                cbThursday.Enabled = true;
                cbFriday.Enabled = true;
                cbSaturday.Enabled = true;
                cbSunday.Enabled = true;
            }
            else
            {
                tbTime1.Enabled = false;
                tbTime2.Enabled = false;
                cbMonday.Enabled = false;
                cbTuesday.Enabled = false;
                cbWednesday.Enabled = false;
                cbThursday.Enabled = false;
                cbFriday.Enabled = false;
                cbSaturday.Enabled = false;
                cbSunday.Enabled = false;
            }
        }

        private void tbnPrevious_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void rbAllExtensions_CheckedChanged(object sender, EventArgs e)
        {
            if (rbAllExtensions.Checked)
            {
                btnSetExtensions.Enabled = false;
            }
            else
            {
                btnSetExtensions.Enabled = true;
                if (dp.MemberList == null)
                    dp.MemberList = new PBXMemberList();
            }
        }

        private void rbSelectedExtensions_CheckedChanged(object sender, EventArgs e)
        {
            if (rbSelectedExtensions.Checked)
            {
                btnSetExtensions.Enabled = true;
                if (dp.MemberList == null)
                    dp.MemberList = new PBXMemberList();
           }
            else
            {
                btnSetExtensions.Enabled = false;
            }
        }

        private void btnSetExtensions_Click(object sender, EventArgs e)
        {
            SelectMemberForm dlg = new SelectMemberForm();
            dlg.pbx = pbx;
            dlg.ml = dp.MemberList;
            dlg.ShowDialog();
        }
    }
}