using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CallBlockList : Form
    {
        public SIPPBX pbx;
        		
        public CallBlockList()
        {
            InitializeComponent();            
        }
        
        public void ShowCallBlockList()
        {
            lvCallBlockList.Items.Clear();

            for (int i = 0; i < pbx.call_blocks.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.call_blocks[i].Caller);
                aItem.SubItems.Add(pbx.call_blocks[i].Callee);
                lvCallBlockList.Items.Add(aItem);
            }
        }
        

        private void btnAdd_Click(object sender, EventArgs e)
        {
            CallBlock cb = new CallBlock();
            CallBlockEdit dlg = new CallBlockEdit();
            dlg.pbx = pbx;
            dlg.cb = cb;

            int maxID = 1;
            for (int i = 0; i < pbx.call_blocks.Count; i++)
            {
                if (pbx.call_blocks[i].ID >= maxID)
                {
                    maxID = pbx.call_blocks[i].ID + 1;
                }
            }

            cb.ID = maxID;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
				if (SIPPBXCFGDB.AddBlackListToDB(cb, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
				{
					pbx.call_blocks.Add(cb);
					ShowCallBlockList();
				}
				else
				{
					MessageBox.Show("Cannot add call block rule into DB.", "Error");
				}

            }
        }

        private void CallBlockList_Load(object sender, EventArgs e)
        {
            lvCallBlockList.Columns.Clear();
            lvCallBlockList.Columns.Add("Caller", 120, HorizontalAlignment.Left);
            lvCallBlockList.Columns.Add("Callee", 120, HorizontalAlignment.Left);
            cbEnable.Checked = pbx.callblock_enabled;

            ShowCallBlockList();
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvCallBlockList.SelectedIndices.Count > 0)
            {
                int idx = lvCallBlockList.SelectedIndices[0];

                CallBlockEdit dlg = new CallBlockEdit();
                dlg.pbx = pbx;
                dlg.cb = pbx.call_blocks[idx];

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (!SIPPBXCFGDB.UpdateBlackListInDB(dlg.cb, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        MessageBox.Show("Cannot update the black list in DB.", "Error");
                    }
                    ShowCallBlockList();
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }

        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvCallBlockList.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                //ACDAgentEdit dlg = new ACDAgentEdit();
                if (SIPPBXCFGDB.RemoveBlackListFromDB(pbx.call_blocks[lvCallBlockList.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.call_blocks.RemoveAt(lvCallBlockList.SelectedIndices[0]);
                    ShowCallBlockList();
                }
                else
                {
                    MessageBox.Show("Cannot remove the item from DB.", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (cbEnable.Checked != pbx.callblock_enabled)
            {
                pbx.callblock_enabled = cbEnable.Checked;
                SIPPBXCFGDB.UpdateCallLimitAndBlackListToDB(null, pbx, null, pbx.db_set.myConn, PBXMainForm.log);
            }

            Close();
        }
    }
}
