﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CallBackEdit : Form
    {
        public CallBack cb;
        public SIPPBX pbx;

        public CallBackEdit()
        {
            InitializeComponent();
        }

        private void CallBackEdit_Load(object sender, EventArgs e)
        {
            tbCaller.Text = cb.Caller;
            tbCallee.Text = cb.Callee;

            int selId = -1;
            int itemCnt = 0;
            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
            {
                if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    continue;

                cbDialplan.Items.Add(pbx.sip_dialplan[i].planName);
                itemCnt++;

                if (cb.DialPlan != "" && cb.DialPlan == pbx.sip_dialplan[i].planName)
                {
                    selId = itemCnt-1;
                }
            }
            if (selId >= 0)
                cbDialplan.SelectedIndex = selId;
            else if (cbDialplan.Items.Count > 0)
                cbDialplan.SelectedIndex = 0;

            selId = -1;
            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                cbSIPAcct.Items.Add(pbx.sip_acct[i].UserName);
                if (cb.ExtraAttr != "" && cb.ExtraAttr == pbx.sip_acct[i].UserName)
                {
                    selId = i;
                }
            }
            if (selId >= 0)
                cbSIPAcct.SelectedIndex = selId;
            else if (cbSIPAcct.Items.Count > 0)
                cbSIPAcct.SelectedIndex = 0;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            cb.Caller = tbCaller.Text.Trim();
            cb.Callee = tbCallee.Text.Trim();
            cb.DialPlan = cbDialplan.Text.Trim();
            cb.ExtraAttr = cbSIPAcct.Text.Trim();
            if (cb.Caller.Length == 0 && cb.Callee.Length == 0)
            {
                MessageBox.Show("Both caller and callee are null string. Invalid!", "Error");
                return;
            }
            if (cb.DialPlan.Length == 0)
            {
                MessageBox.Show("Dialplan is null. Invalid!", "Error");
                return;
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}
