using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ACDHuntGroupList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public ACDHuntGroupList()
        {
            InitializeComponent();
        }

        private void ACDHuntGroupList_Load(object sender, EventArgs e)
        {
            lvHuntgroups.Columns.Clear();
            lvHuntgroups.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvHuntgroups.Columns.Add("Type", 120, HorizontalAlignment.Left);
            lvHuntgroups.Columns.Add("Agents", 240, HorizontalAlignment.Left);

            cbUseGroupName.Checked = pbx.use_gpname_as_dispname;

            ShowHuntGroupList();
        }

        public void ShowHuntGroupList()
        {
            lvHuntgroups.Items.Clear();

            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_huntgroups[i].hgName);
                if(pbx.sip_huntgroups[i].hgType == 0)
                    aItem.SubItems.Add("Linear");
                else if (pbx.sip_huntgroups[i].hgType == 1)
                    aItem.SubItems.Add("Circular");
                else if (pbx.sip_huntgroups[i].hgType == 2)
                    aItem.SubItems.Add("Most Idle");
                else if (pbx.sip_huntgroups[i].hgType == 3)
                    aItem.SubItems.Add("Most Skill");

                String sAgentList = "";;
                for (int j = 0; j < pbx.sip_huntgroups[i].agents.Count; j++)
                {
                    sAgentList += pbx.sip_huntgroups[i].agents[j];
                    if(j != pbx.sip_huntgroups[i].agents.Count-1)
                        sAgentList += ";";
                }
                aItem.SubItems.Add(sAgentList);

                lvHuntgroups.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            ACDHuntGroupAdd dlg = new ACDHuntGroupAdd();
            dlg.pbx = pbx;
            dlg.parent_dlg = this;
            if(dlg.ShowDialog() == DialogResult.OK)
            {
                //////////////////////////////////////////////

            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvHuntgroups.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveACDConfigFromDB(pbx.sip_huntgroups[lvHuntgroups.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.sip_huntgroups.RemoveAt(lvHuntgroups.SelectedIndices[0]);
                    lvHuntgroups.Items.RemoveAt(lvHuntgroups.SelectedIndices[0]);
                }
                else
                    MessageBox.Show("Cannot delete a hunt group!", "Error");
            }
            else
            {
                MessageBox.Show("Please select a hunt group first!", "Error");
            }

        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvHuntgroups.SelectedIndices.Count > 0)
            {
                ACDHuntGroupAdd dlg = new ACDHuntGroupAdd();
                dlg.pbx = pbx;
                dlg.parent_dlg = this;
                dlg.hg = pbx.sip_huntgroups[lvHuntgroups.SelectedIndices[0]];
                dlg.ShowDialog();
            }
            else
            {
                MessageBox.Show("Please select a Hunt Group first!", "Error");
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnSetAgents_Click(object sender, EventArgs e)
        {
            if(main_form.serviceRunning)
                main_form.RefreshACDAgentStatus(null);

            ACDAgentList dlg = new ACDAgentList();
            dlg.pbx = pbx;
            dlg.ShowDialog();

            SIPPBXDBUtil.InitAgentStatusTable(pbx, null, pbx.db_set.myConn);
        }

        private void cbUseGroupName_CheckedChanged(object sender, EventArgs e)
        {
            pbx.use_gpname_as_dispname = cbUseGroupName.Checked;
            SIPPBXCFGDB.UpdateSysUseGroupNameAsDisplayNameToDB(null, pbx, null, pbx.db_set.myConn, PBXMainForm.log);
        }

    }
}