using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class VoiceMailBoxEdit : Form
    {
        public SIPPBX pbx;
        public VoiceMailBox vmb;

        public VoiceMailBoxEdit()
        {
            InitializeComponent();
        }

        private void VoiceMailBoxEdit_Load(object sender, EventArgs e)
        {
            if (vmb.vmbPrompt.Length > 0)
                tbVoicePrompt.Text = vmb.vmbPrompt;
            else
                tbVoicePrompt.Text = pbx.please_leave_your_message_after_beep_dir;

            if (vmb.vmbExten != null && vmb.vmbEmailAddr.Length == 0)
            {
                tbEmailAddr.Text = vmb.vmbExten.Email;
                //tbEmailAddr.Enabled = false;
            }
            else
            {
                tbEmailAddr.Text = vmb.vmbEmailAddr;
            }

            tbMaxLength.Text = vmb.maxLengthInSecond.ToString();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbVoicePrompt.Text = openFileDialog1.FileName;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            vmb.vmbPrompt = tbVoicePrompt.Text;
            //if (vmb.vmbExten == null)
            //{
                vmb.vmbEmailAddr = tbEmailAddr.Text;
            //}

            vmb.maxLengthInSecond = Convert.ToInt32(tbMaxLength.Text);

            Close();

            DialogResult = DialogResult.OK;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Close();
            DialogResult = DialogResult.Cancel;
        }
    }
}