using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SelectExtenForm : Form
    {
        public SIPPBX pbx;
        public SIPPBXExten sel_ext;
        
        public SelectExtenForm()
        {
            InitializeComponent();
            pbx = null;
            sel_ext = null;
        }

        private void SelectExtenForm_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                SIPPBXExten ext = pbx.sip_exten[i];
                if (!ext.IsVirtualExten())
                {
                    //if (ext.IsRegistered())
                    {
                        cbExtensions.Items.Add(ext.UserName);
                    }
                }
                else
                {
                    cbExtensions.Items.Add(ext.UserName);
                }
            }

            if (cbExtensions.Items.Count > 0)
            {
                cbExtensions.SelectedIndex = 0;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            sel_ext = pbx.getExtensionByName(cbExtensions.Text);
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}