using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class PickupGroupList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public PickupGroupList()
        {
            InitializeComponent();
        }

        private void PickupGroupList_Load(object sender, EventArgs e)
        {
            lvPickupGroups.Columns.Clear();
            lvPickupGroups.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvPickupGroups.Columns.Add("Type", 120, HorizontalAlignment.Left);
            lvPickupGroups.Columns.Add("Members", 240, HorizontalAlignment.Left);

            ShowPickupGroupList();
        }

        public void ShowPickupGroupList()
        {
            lvPickupGroups.Items.Clear();
            for (int i = 0; i < pbx.pickup_groups.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.pickup_groups[i].name);
                if (pbx.pickup_groups[i].ml.mb_type == 0)
                    aItem.SubItems.Add("Extension");
                else
                    aItem.SubItems.Add("Agent");

                string sDests = "";
                for (int j = 0; j < pbx.pickup_groups[i].ml.members.Count; j++)
                    sDests += pbx.pickup_groups[i].ml.members[j] + ";";
                aItem.SubItems.Add(sDests);
                lvPickupGroups.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            PickUpGroup pg = new PickUpGroup();
            PickupGroupEdit dlg = new PickupGroupEdit();
            dlg.pk_group = pg;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddPickUpGroupToDB(pg, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.pickup_groups.Add(pg);
                    ShowPickupGroupList();
                }
                else
                {
                    MessageBox.Show("Cannot add pickup group into database table!", "Error");
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            PickUpGroup pg;
            if (lvPickupGroups.SelectedIndices.Count >= 1)
            {
                pg = pbx.pickup_groups[lvPickupGroups.SelectedIndices[0]];
                PickupGroupEdit dlg = new PickupGroupEdit();
                dlg.pbx = pbx;
                dlg.pk_group = pg;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (SIPPBXCFGDB.UpdatePickUpGroupInDB(pg, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                    }
                    else
                    {
                        MessageBox.Show("Cannot update pickup group in database table!", "Error");
                    }
                    ShowPickupGroupList();
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }

        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvPickupGroups.SelectedIndices.Count >= 1)
            {
                if (SIPPBXCFGDB.RemovePickUpGroupFromDB(pbx.pickup_groups[lvPickupGroups.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.pickup_groups.RemoveAt(lvPickupGroups.SelectedIndices[0]);
                    lvPickupGroups.Items.RemoveAt(lvPickupGroups.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Cannot remove pickup group from database table!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }



    }
}