using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ParkingSlotList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public ParkingSlotList()
        {
            InitializeComponent();
        }

        void ShowParkingSlotList()
        {
            lvParkingSlot.Items.Clear();

            for (int i = 0; i < pbx.sip_parkingslots.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_parkingslots[i].psName);
                aItem.SubItems.Add(pbx.sip_parkingslots[i].psDTMF);
                lvParkingSlot.Items.Add(aItem);
            }
        }

        private void ParkingSlotList_Load(object sender, EventArgs e)
        {
            lvParkingSlot.Columns.Clear();
            lvParkingSlot.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvParkingSlot.Columns.Add("Number", 120, HorizontalAlignment.Left);

            ShowParkingSlotList();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            ParkingSlotEdit dlg = new ParkingSlotEdit();
            dlg.ps = new SIPPBXParkingSlot();
            dlg.pbx = pbx;
            if(dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddParkingSlotToDB(dlg.ps, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.sip_parkingslots.Add(dlg.ps);
                    ShowParkingSlotList();
                }
                else
                {
                    MessageBox.Show("Cannot add the parking slot into DB!", "Error");
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            SIPPBXParkingSlot ps;
            if (lvParkingSlot.SelectedIndices.Count >= 1)
            {
                ps = pbx.sip_parkingslots[lvParkingSlot.SelectedIndices[0]];
                ParkingSlotEdit dlg = new ParkingSlotEdit();
                dlg.ps = ps;
                dlg.pbx = pbx;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (!SIPPBXCFGDB.UpdateParkingSlotInDB(dlg.ps, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        MessageBox.Show("Cannot update parking slot in DB!", "Error");
                    }
                    ShowParkingSlotList();
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvParkingSlot.SelectedIndices.Count >= 1)
            {
                if (SIPPBXCFGDB.RemoveParkingSlotFromDB(pbx.sip_parkingslots[lvParkingSlot.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.sip_parkingslots.RemoveAt(lvParkingSlot.SelectedIndices[0]);
                    lvParkingSlot.Items.RemoveAt(lvParkingSlot.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Cannot remove the parking slot from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}