using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ParkingSlotEdit : Form
    {
        public SIPPBX pbx;
        public SIPPBXParkingSlot ps;
        public VoiceMailBox vmb;

        public ParkingSlotEdit()
        {
            InitializeComponent();
        }

        private void ParkingSlotEdit_Load(object sender, EventArgs e)
        {
            tbName.Text = ps.psName;
            if (ps.psName.Length > 0)
                tbName.Enabled = false;

            tbNumber.Text = ps.psDTMF;
            cbPlayMOH.Checked = ps.playMOH;
            if (ps.playMOH)
            {
                tbMOHDir.Enabled = true;
                btnBrowse.Enabled = true;
                if (ps.mohDir.Length > 0)
                {
                    tbMOHDir.Text = ps.mohDir;
                }
                else
                {
                    tbMOHDir.Text = pbx.moh_dir;
                }
            }
            else
            {
                tbMOHDir.Enabled = false;
                btnBrowse.Enabled = false;
            }

            vmb = ps.vmb;
            if (vmb != null)
            {
                cbVMB.Checked = true;
                tbVMBDTMF.Enabled = true;
                tbVMBDTMF.Text = ps.vmbDTMF;
                btnVMBSet.Enabled = true;
            }
            else
            {
                cbVMB.Checked = false;
                tbVMBDTMF.Enabled = false;
                btnVMBSet.Enabled = false;
            }

            tbDPDTMF.Text = ps.dpDTMF;
            tbWaitTimeout.Text = ps.waitTimeout.ToString();

            if (ps.waitTimeoutTo.Length > 0)
            {
                rbTimeoutToVMB.Checked = false;
                rbTimeoutToDP.Checked = true;
            }
            else
            {
                rbTimeoutToVMB.Checked = true;
                rbTimeoutToDP.Checked = false;
            }

            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
            {
                if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                {
                    cbToDiaplan.Items.Add(pbx.sip_dialplan[i].planName);
                }
            }
            cbToDiaplan.Text = ps.dpName;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            ps.psName = tbName.Text;
            ps.psDTMF = tbNumber.Text;
            ps.playMOH = cbPlayMOH.Checked;
            if (ps.playMOH)
                ps.mohDir = tbMOHDir.Text;
            else
                ps.mohDir = "";
            ps.vmbDTMF = tbVMBDTMF.Text;
            if (cbVMB.Checked)
                ps.vmb = vmb;
            else
                ps.vmb = null;

            ps.dpDTMF = tbDPDTMF.Text;
            ps.dpName = cbToDiaplan.Text;
            ps.waitTimeout = Convert.ToInt32(tbWaitTimeout.Text);
            ps.waitTimeoutTo = rbTimeoutToDP.Checked ? cbToDiaplan.Text : "";

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void cbPlayMOH_CheckedChanged(object sender, EventArgs e)
        {
            if (cbPlayMOH.Checked)
            {
                tbMOHDir.Enabled = true;
                btnBrowse.Enabled = true;
                if (ps.mohDir.Length > 0)
                {
                    tbMOHDir.Text = ps.mohDir;
                }
                else
                {
                    tbMOHDir.Text = pbx.moh_dir;
                }
            }
            else
            {
                tbMOHDir.Enabled = false;
                btnBrowse.Enabled = false;
            }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a music folder";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbMOHDir.Text = myBrowser.DirectoryPath;
            }
        }

        private void cbVMB_CheckedChanged(object sender, EventArgs e)
        {
            if (cbVMB.Checked)
            {
                tbVMBDTMF.Enabled = true;
                tbVMBDTMF.Text = ps.vmbDTMF;
                btnVMBSet.Enabled = true;

                if (vmb == null)
                    vmb = new VoiceMailBox();
            }
            else
            {
                tbVMBDTMF.Enabled = false;
                btnVMBSet.Enabled = false;
                vmb = null;
            }
        }

        private void btnVMBSet_Click(object sender, EventArgs e)
        {
            if (vmb == null)
                vmb = new VoiceMailBox();

            VoiceMailBoxEdit dlg = new VoiceMailBoxEdit();
            dlg.vmb = vmb;
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }


    }
}