using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class PBXV2About : Form
    {
        public PBXMainForm parent_form;
        public SIPPBX pbx;

        public PBXV2About()
        {
            InitializeComponent();
            parent_form = null;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void PBXV2About_Load(object sender, EventArgs e)
        {
            if (parent_form.SelfBrand.Length > 0)
            {
                label1.Text = parent_form.SelfBrand + " version " + parent_form.PBXVersion;
                label2.Visible = false;
                linkLabel1.Text = parent_form.SelfBrandWebLink;
                linkLabel2.Visible = false;
                label3.Visible = false;
                pictureBox2.Visible = false;

                label7.Visible = false;
                label4.Visible = false;
                label5.Visible = false;
                label6.Visible = false;
                linkLabel3.Visible = false;
                linkLabel4.Visible = false;
                linkLabel5.Visible = false;
            }
            else
            {
                label1.Text = "PC Best Networks SIP PBX version " + parent_form.PBXVersion + "\r\nCopyright @ PC Best Networks Inc. 2011";

                if (!pbx.bFreeVersion)
                {
                    label3.Text = "SIP PBX PRO Version(" + pbx.ChanNum.ToString() + " Channels)";
                    linkLabel2.Visible = false;
                }

                pictureBox2.Visible = true;
            }
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                if(parent_form.SelfBrand.Length > 0)
                    System.Diagnostics.Process.Start(parent_form.SelfBrandWebLink);
                else
                    System.Diagnostics.Process.Start("http://www.pcbest.net/contact.php");

                linkLabel1.LinkVisited = true;
            }
            catch(Exception)
            {
            }
        }

        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                System.Diagnostics.Process.Start("http://www.pcbest.net/prices.php");
                linkLabel2.LinkVisited = true;
            }
            catch (Exception)
            {
            }
        }
    }
}