using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class PBXSystemSetForm : Form
    {
        public SIPPBX pbx;

        public PBXSystemSetForm()
        {
            InitializeComponent();
        }

        private void PBXSystemSetForm_Load(object sender, EventArgs e)
        {
            tbOutPercent.Text = pbx.pbx_sys_set.OutPercent.ToString();
            tbMaxRegExpireSec.Text = pbx.pbx_sys_set.MaxProxyUserRegSec.ToString();
            cbExtenCanTryInbound.Checked = pbx.pbx_sys_set.bExtenCanInbound;
            tbExtenCodec.Text = pbx.pbx_sys_set.PreferExtensionCodec;
            tbOutlineCodec.Text = pbx.pbx_sys_set.PreferOutlineCodec;
            tbRestartTime.Text = pbx.pbx_sys_set.sRestartTime;
            cbPlayMOHRandom.Checked = pbx.pbx_sys_set.bRandomPlayMOH;
            cbRingbackTone.Checked = pbx.pbx_sys_set.bPlayRingbackTone;
            cbStopPlayingForFirstKey.Checked = pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey;

            cbNoAudioDisconnect.Checked = pbx.pbx_sys_set.bNoAudioDisconnect;
            tbMaxCallDuration.Text = pbx.pbx_sys_set.MaxCallDuration.ToString();
            cbGetRemoteContact.Checked = pbx.get_remote_contact_from_ring;

            rbWAV.Checked = pbx.AudioFormat == 0;
            rdMP3.Checked = pbx.AudioFormat == 1;
            rdGSM.Checked = pbx.AudioFormat == 2;
            cbEncode.Checked = pbx.AudioEncode == 1;

            if (cbNoAudioDisconnect.Checked)
            {
                tbNoAudioSeconds.Enabled = true;
                if (pbx.pbx_sys_set.NoAudioDisconnectDur <= 10)
                    pbx.pbx_sys_set.NoAudioDisconnectDur = 10; //at least 10 seconds

                tbNoAudioSeconds.Text = pbx.pbx_sys_set.NoAudioDisconnectDur.ToString();
            }
            else
                tbNoAudioSeconds.Enabled = false;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            pbx.pbx_sys_set.bExtenCanInbound = cbExtenCanTryInbound.Checked;
            pbx.pbx_sys_set.MaxProxyUserRegSec = Convert.ToInt32(tbMaxRegExpireSec.Text);
            if (pbx.pbx_sys_set.MaxProxyUserRegSec < 300)
                pbx.pbx_sys_set.MaxProxyUserRegSec = 300;
            else if (pbx.pbx_sys_set.MaxProxyUserRegSec > 3600)
                pbx.pbx_sys_set.MaxProxyUserRegSec = 3600;

            pbx.pbx_sys_set.OutPercent = Convert.ToInt32(tbOutPercent.Text);
            if (pbx.pbx_sys_set.OutPercent > 100)
                pbx.pbx_sys_set.OutPercent = 100;
            else if (pbx.pbx_sys_set.OutPercent < 0)
                pbx.pbx_sys_set.OutPercent = 0;

            pbx.pbx_sys_set.PreferExtensionCodec = tbExtenCodec.Text;
            pbx.pbx_sys_set.PreferOutlineCodec = tbOutlineCodec.Text;

            pbx.pbx_sys_set.sRestartTime = tbRestartTime.Text;

            pbx.pbx_sys_set.bRandomPlayMOH = cbPlayMOHRandom.Checked;

            pbx.pbx_sys_set.bPlayRingbackTone = cbRingbackTone.Checked;

            pbx.pbx_sys_set.bNoAudioDisconnect = cbNoAudioDisconnect.Checked;

            pbx.pbx_sys_set.MaxCallDuration = Convert.ToInt32(tbMaxCallDuration.Text);

            pbx.get_remote_contact_from_ring = cbGetRemoteContact.Checked;

            pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey = cbStopPlayingForFirstKey.Checked;

            if(rbWAV.Checked)
                pbx.AudioFormat = 0;
            else if(rdMP3.Checked)
                pbx.AudioFormat = 1;
            else if(rdGSM.Checked)
                pbx.AudioFormat = 2;
            else
                pbx.AudioFormat = 0;

            if(cbEncode.Checked)
                pbx.AudioEncode = 1;
            else
                pbx.AudioEncode = 0;

            if (pbx.pbx_sys_set.bNoAudioDisconnect)
            {
                pbx.pbx_sys_set.NoAudioDisconnectDur = Convert.ToInt32(tbNoAudioSeconds.Text);
                if (pbx.pbx_sys_set.NoAudioDisconnectDur <= 10)
                    pbx.pbx_sys_set.NoAudioDisconnectDur = 10; //at least 10 seconds
            }
            else
            {
                pbx.pbx_sys_set.NoAudioDisconnectDur = 10;
            }

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void cbNoAudioDisconnect_CheckedChanged(object sender, EventArgs e)
        {
            if (cbNoAudioDisconnect.Checked)
            {
                tbNoAudioSeconds.Enabled = true;
                if (pbx.pbx_sys_set.NoAudioDisconnectDur <= 10)
                    pbx.pbx_sys_set.NoAudioDisconnectDur = 10; //at least 10 seconds

                tbNoAudioSeconds.Text = pbx.pbx_sys_set.NoAudioDisconnectDur.ToString();
            }
            else
                tbNoAudioSeconds.Enabled = false;
        }

        private void groupBox2_Enter(object sender, EventArgs e)
        {

        }

    }
}