using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class MonitorGroupEdit : Form
    {
        public SIPPBXMonitorGroup mg;
        public SIPPBX pbx;

        public MonitorGroupEdit()
        {
            InitializeComponent();
        }

        private void MonitorGroupEdit_Load(object sender, EventArgs e)
        {
            tbName.Text = mg.mgName;
            if (mg.mgName.Length > 0)
                tbName.Enabled = false;

            tbNumber.Text = mg.mgNumber;
            tbPasswordPrompt.Text = mg.mgPasswordPrompt;
            tbPassword.Text = mg.mgPassword;
            tbBargeIn.Text = mg.mgKeyBargeIn;
            tbBargeOut.Text = mg.mgKeyOut;
            tbKeyWhisper.Text = mg.mgKeyWhisper;
            tbExtenPrompt.Text = mg.mgExtenPrompt;

            if (pbx.sip_exten.Count > 0)
            {
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                    cbExtensions.Items.Add(pbx.sip_exten[i].UserName);

                cbExtensions.SelectedIndex = 0;
            }
            
            if (mg.mgAllExtens)
            {
                rbAllExtens.Checked = true;
                rbSpecifyExten.Checked = false;
                lbExtensions.Enabled = false;
                btnAddExten.Enabled = false;
                btnDelExten.Enabled = false;
                cbExtensions.Enabled = false;
            }
            else
            {
                rbAllExtens.Checked = false;
                rbSpecifyExten.Checked = true;
                lbExtensions.Enabled = true;
                btnAddExten.Enabled = true;
                btnDelExten.Enabled = true;
                if (pbx.sip_exten.Count > 0)
                    cbExtensions.Enabled = true;
                ShowExtensions();
            }
        }

        public void ShowExtensions()
        {
            lbExtensions.Items.Clear();
            for (int i = 0; i < mg.mgExtenList.Count; i++)
            {
                lbExtensions.Items.Add(mg.mgExtenList[i]);
            }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbPasswordPrompt.Text = openFileDialog1.FileName;
            }
        }

        private void btnExtenPromptBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbExtenPrompt.Text = openFileDialog1.FileName;
            }
        }

        private void rbAllExtens_CheckedChanged(object sender, EventArgs e)
        {
            if (rbAllExtens.Checked)
            {
                lbExtensions.Enabled = false;
                btnAddExten.Enabled = false;
                btnDelExten.Enabled = false;
                cbExtensions.Enabled = false;
            }
            else
            {
                lbExtensions.Enabled = true;
                btnAddExten.Enabled = true;
                btnDelExten.Enabled = true;
                if (pbx.sip_exten.Count > 0)
                    cbExtensions.Enabled = true;
                ShowExtensions();
            }
        }

        private void rbSpecifyExten_CheckedChanged(object sender, EventArgs e)
        {
            if (!rbSpecifyExten.Checked)
            {
                lbExtensions.Enabled = false;
                btnAddExten.Enabled = false;
                btnDelExten.Enabled = false;
                cbExtensions.Enabled = false;
            }
            else
            {
                lbExtensions.Enabled = true;
                btnAddExten.Enabled = true;
                btnDelExten.Enabled = true;
                if (pbx.sip_exten.Count > 0)
                    cbExtensions.Enabled = true;
                ShowExtensions();
            }
        }

        private void btnAddExten_Click(object sender, EventArgs e)
        {
            if (pbx.sip_exten.Count > 0 && cbExtensions.SelectedIndex >= 0)
            {
                string extn_name = pbx.sip_exten[cbExtensions.SelectedIndex].UserName;
                bool found = false;
                for (int i = 0; i < lbExtensions.Items.Count; i++)
                {
                    string item = (string)lbExtensions.Items[i];
                    if (item == extn_name)
                    {
                        found = true;
                        break;
                    }
                }
                if (!found)
                {
                    lbExtensions.Items.Add(extn_name);
                }
                else
                {
                    MessageBox.Show("Exension is already in the list", "Error");
                }
            }
        }

        private void btnDelExten_Click(object sender, EventArgs e)
        {
            if (pbx.sip_exten.Count > 0 && lbExtensions.SelectedIndex >= 0)
            {
                lbExtensions.Items.RemoveAt(lbExtensions.SelectedIndex);
            }
            else
            {
                MessageBox.Show("Please select one item in the list first.", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            mg.mgName = tbName.Text;
            mg.mgNumber = tbNumber.Text;

            mg.mgPasswordPrompt = tbPasswordPrompt.Text;
            mg.mgPassword = tbPassword.Text;

            mg.mgKeyBargeIn = tbBargeIn.Text;
            mg.mgKeyOut = tbBargeOut.Text;
            mg.mgKeyWhisper = tbKeyWhisper.Text;

            mg.mgExtenPrompt = tbExtenPrompt.Text;

            if (rbAllExtens.Checked)
            {
                mg.mgAllExtens = true;
                mg.mgExtenList.Clear();
            }
            else
            {
                mg.mgAllExtens = false;
                mg.mgExtenList.Clear();
                for (int i = 0; i < lbExtensions.Items.Count; i++)
                    mg.mgExtenList.Add((string)lbExtensions.Items[i]);
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }


    }
}