using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
using System.IO;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Reflection;
using SIPPBXv3;
using System.Data.SqlClient;
using System.Threading;

namespace SIPPBXGUI
{
    public partial class PBXMainForm : Form
    {
        public string SelfBrand;
        public string PBXVersion;
        public string SelfBrandWebLink;

        private SIPPBX pbx;
        public static SIPPBXGUILog log;

        public TreeNode tn_pbx;
        public TreeNode tn_extens;
        public TreeNode tn_sip_accounts;
        public TreeNode tn_dial_plans;
        public TreeNode tn_hunt_groups;
        public TreeNode tn_chans;
        public TreeNode tn_parking_slot;
        public TreeNode tn_ring_groups;
        public TreeNode tn_monitor_groups;
        public TreeNode tn_acd_agents;
        public TreeNode tn_ivrs;
        public TreeNode tn_conferooms;

        public TreeNode tn_curSel;

        //private int Timer_Count;

        public Bitmap bmpUserOffline;
        public Bitmap bmpUserIdle;
        public Bitmap bmpUserInCall;

        public Bitmap bmpChanIdle;
        public Bitmap bmpChanFlashing;
        public Bitmap bmpChanInCall;

        public bool serviceRunning;

        public Int64 logID;
        public DateTime logTimeSince;

        //private static bool First2SecondsProcessDone;

        public PBXMainForm()
        {
            InitializeComponent();

            logID = -1;
            logTimeSince = DateTime.Now;

            log = new SIPPBXGUILog();
            log.mMainForm = this;

            pbx = new SIPPBX();

            SelfBrand = "";
            SelfBrandWebLink = "";

            //SelfBrand = "Cast-Iron Communications SIP PBX";
            //SelfBrandWebLink = "http://www.cast-iron.net/";

            //SelfBrand = "AktifTelecom TalksPBX";
            //SelfBrandWebLink = "http://www.aktiftelecom.com/";

            //SelfBrand = "iFoneline IPPBX";
            //SelfBrandWebLink = "http://www.ifoneline.com.au";

            //SelfBrand = "ENACCS Communications PBX";
            //SelfBrandWebLink = "http://www.enaccs.com/";

            //SelfBrand = "EasyVo IP PBX";
            //SelfBrandWebLink = "http://www.easyvo.com/";

            //SelfBrand = "Empatiq Communication IP PBX";
            //SelfBrandWebLink = "http://www.empatiq.com/";

            pbx.PBXVersion = PBXVersion = "3.61";

            //Timer_Count = 0;

			//dbPBXSet = null;

            tn_curSel = null;

            serviceRunning = false;
        }

        public void LogoutText(string sLogInfo/*, bool bTrace*/)
        {
            lock (this)
            {
                sLogInfo = "[" + SIPPBXWinUtil.GetSQLDateTime(DateTime.Now) + "]" + " " + sLogInfo;
                if (LogRichEdit.Text.Length > 1024 * 512)
                    LogRichEdit.Text = "";
                LogRichEdit.Text = LogRichEdit.Text + sLogInfo + "\r\n";
                LogRichEdit.Select(LogRichEdit.Text.Length - 2, 1);
                LogRichEdit.ScrollToCaret();
            }
        }

        public void GetPBXVersionFromDB()
        {
            string v = SIPPBXCFGDB.GetSysPBXVersionSettingsFromDB(null, pbx, null, pbx.db_set.myConn, PBXMainForm.log);
            if(v.Length > 0)
                PBXVersion = v;

            if (SelfBrand.Length > 0)
                Text = SelfBrand + " v" + PBXVersion + " (Admin Tool)";
            else
                Text = "PC Best Networks SIP PBX v" + PBXVersion + " (Admin Tool)";
        }

        public int LoadConfig()
        {
            int cfgType = SIPPBXCFG.LoadConfigFromXML(pbx.pbx_dir + "\\sippbxv3.xml", pbx, null);

            if (cfgType == 0)
            {
                //file not found
                LogoutText("File(" + pbx.pbx_dir + "\\sippbxv3.xml) NOT found!");
                MessageBox.Show("File(" + pbx.pbx_dir + "\\sippbxv3.xml) NOT found!", "Error");
            }
            else if (cfgType == 1)
            {
                //from database
                if (pbx.db_set.ConnectDB())
                {
                    pbx.db_set.TestTables();
                    SIPPBXCFGDB.LoadAllCfgFromDB(null, pbx, null, PBXMainForm.log);
                    GetPBXVersionFromDB();
                }
                else
                {
                    if (pbx.db_set.CanConnectMaster())
                    {
                        if (!pbx.db_set.CheckDatabaseExists(""))
                        {
                            pbx.db_set.CreateDB(pbx);
                            Thread.Sleep(5000);
                        }

                        int retrymax = 0;
                        while (!pbx.db_set.ConnectDB() && retrymax++ < 6)
                        {
                            Thread.Sleep(5000);
                        }

                        if (pbx.db_set.IsDBConnected())
                        {
                            pbx.db_set.TestTables();
                            SIPPBXCFGDB.LoadAllCfgFromDB(null, pbx, null, PBXMainForm.log);
                            GetPBXVersionFromDB();
                        }
                        else
                        {
                            LogoutText("Cannot connect to DB! Please check the database settings in file: " + pbx.pbx_dir + "\\sippbxv3.xml");
                            MessageBox.Show("Cannot connect to DB! Please check the database settings in file: " + pbx.pbx_dir + "\\sippbxv3.xml", "Error");
                            cfgType = 0;
                        }
                    }
                    else
                    {
                        LogoutText("Cannot connect to DB! Please check the database settings in file: " + pbx.pbx_dir + "\\sippbxv3.xml");
                        MessageBox.Show("Cannot connect to DB! Please check the database settings in file: " + pbx.pbx_dir + "\\sippbxv3.xml", "Error");
                        cfgType = 0;
                    }
                }
            }
            else if (cfgType == 2)
            {
                //from Regsitry
                LogoutText("Regsitry configuration is NOT supported!");
                MessageBox.Show("Regsitry configuration is NOT supported!", "Error");
            }
            else if (cfgType == 3)
            {
                //from XML
                LogoutText("XML configuration is NOT supported!");
                MessageBox.Show("XML configuration is NOT supported!", "Error");
            }

            return cfgType;
        }


        private void PBXMainForm_Load(object sender, EventArgs e)
        {
            if (LoadConfig() != 1)
            {
                //only support db config now
                Close();
                return;
            }

            pbx.chan_list = new SIPPBXChan[pbx.ChanNum];
            for (int i = 0; i < pbx.ChanNum; i++)
            {
                pbx.chan_list[i] = new SIPPBXChan(i);
            }

            timer1.Enabled = true; 
            
            dataGridView1.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
            dataGridView1.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.DisplayedCellsExceptHeaders;


//////////////////bitmaps

            Stream imgStream = null;

            // get a reference to the current assembly
            Assembly a = Assembly.GetExecutingAssembly();
            imgStream = a.GetManifestResourceStream("SIPPBXGUI.Resources.user offline.png");
            if (imgStream != null)
            {
                // create a new bitmap from this stream and 
                // add it to the arraylist
                bmpUserOffline = new Bitmap(imgStream);
                imgStream.Close();
            }
            imgStream = null;

            imgStream = a.GetManifestResourceStream("SIPPBXGUI.Resources.user reg.png");
            if (imgStream != null)
            {
                // create a new bitmap from this stream and 
                // add it to the arraylist
                bmpUserIdle = new Bitmap(imgStream);
                imgStream.Close();
            }
            imgStream = null;

            imgStream = a.GetManifestResourceStream("SIPPBXGUI.Resources.user chat.png");
            if (imgStream != null)
            {
                // create a new bitmap from this stream and 
                // add it to the arraylist
                bmpUserInCall = new Bitmap(imgStream);
                imgStream.Close();
            }
            imgStream = null;

            imgStream = a.GetManifestResourceStream("SIPPBXGUI.Resources.channel gray.png");
            if (imgStream != null)
            {
                // create a new bitmap from this stream and 
                // add it to the arraylist
                bmpChanIdle = new Bitmap(imgStream);
                imgStream.Close();
            }
            imgStream = null;

            imgStream = a.GetManifestResourceStream("SIPPBXGUI.Resources.channel orange.png");
            if (imgStream != null)
            {
                // create a new bitmap from this stream and 
                // add it to the arraylist
                bmpChanFlashing = new Bitmap(imgStream);
                imgStream.Close();
            }
            imgStream = null;

            imgStream = a.GetManifestResourceStream("SIPPBXGUI.Resources.channel green.png");
            if (imgStream != null)
            {
                // create a new bitmap from this stream and 
                // add it to the arraylist
                bmpChanInCall = new Bitmap(imgStream);
                imgStream.Close();
            }
            imgStream = null;

            try
            {
                if (SIPPBXWinUtil.GetWinServiceStatus("SIP PBX v3") == System.ServiceProcess.ServiceControllerStatus.Stopped)
                {
                    //if (MessageBox.Show("SIP PBX v3 service is not running. Do you want to start it?", "Warning", MessageBoxButtons.YesNo) == DialogResult.Yes)
                    //{
                    //    StartPBX();
                    //}
                    //else
                    {
                        tvMainForm.Enabled = false;
                        serviceRunning = false;

                        startPBXToolStripMenuItem.Enabled = true;
                        stopPBXToolStripMenuItem.Enabled = false;
                        restartPBXToolStripMenuItem.Enabled = false;

                        sIPAccountToolStripMenuItem.Enabled = false;
                        extensionsToolStripMenuItem.Enabled = false;
                        aCDHuntGroupsToolStripMenuItem.Enabled = false;
                        parkingSlotToolStripMenuItem.Enabled = false;
                        ringGroupsToolStripMenuItem.Enabled = false;
                        iVRMenusToolStripMenuItem.Enabled = false;
                        conferenceRoomsToolStripMenuItem.Enabled = false;
                        dialPlanToolStripMenuItem.Enabled = false;
                        monitorGroupsToolStripMenuItem.Enabled = false;
                        pickupGroupsToolStripMenuItem.Enabled = false;

                        tasksToolStripMenuItem.Enabled = false;
                        addTasksToolStripMenuItem.Enabled = false;

                        callTimeLimitRulesToolStripMenuItem.Enabled = false;
                        callBlackListToolStripMenuItem.Enabled = false;

                        toolStripBtnPlay.Enabled = true;
                        toolStripBtnStop.Enabled = false;

                        LogoutText("SIP PBX v3 Service is NOT running! Please click Start PBX menu.");
                    }
                }
                else
                {
                    tvMainForm.Enabled = true;
                    serviceRunning = true;

                    startPBXToolStripMenuItem.Enabled = false;
                    stopPBXToolStripMenuItem.Enabled = true;
                    restartPBXToolStripMenuItem.Enabled = true;

                    sIPAccountToolStripMenuItem.Enabled = true;
                    extensionsToolStripMenuItem.Enabled = true;
                    aCDHuntGroupsToolStripMenuItem.Enabled = true;
                    parkingSlotToolStripMenuItem.Enabled = true;
                    ringGroupsToolStripMenuItem.Enabled = true;
                    iVRMenusToolStripMenuItem.Enabled = true;
                    conferenceRoomsToolStripMenuItem.Enabled = true;
                    dialPlanToolStripMenuItem.Enabled = true;
                    monitorGroupsToolStripMenuItem.Enabled = true;
                    pickupGroupsToolStripMenuItem.Enabled = true;

                    tasksToolStripMenuItem.Enabled = true;
                    addTasksToolStripMenuItem.Enabled = true;

                    callTimeLimitRulesToolStripMenuItem.Enabled = true;
                    callBlackListToolStripMenuItem.Enabled = true;

                    toolStripBtnPlay.Enabled = false;
                    toolStripBtnStop.Enabled = true;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
            
            RebuildMainTreeView();
        }

        public void RebuildMainTreeView()
        {
            //if (!serviceRunning) return;

            //remember where it is right now
            TreeNode tnSel = tvMainForm.SelectedNode;
            int nSelIndex = -1;

            if (pbx == null) return;

            if (tnSel != null)
            {
                if (tnSel.Parent == tn_extens)
                {
                    nSelIndex = 0;
                }
                else if (tnSel.Parent == tn_sip_accounts)
                {
                    nSelIndex = 1;
                }
                else if (tnSel.Parent == tn_dial_plans)
                {
                    nSelIndex = 2;
                }
                else if (tnSel.Parent == tn_acd_agents)
                {
                    nSelIndex = 3;
                }
                else if (tnSel.Parent == tn_hunt_groups)
                {
                    nSelIndex = 4;
                }
                else if (tnSel.Parent == tn_parking_slot)
                {
                    nSelIndex = 5;
                }
                else if (tnSel.Parent == tn_ring_groups)
                {
                    nSelIndex = 6;
                }
                else if (tnSel.Parent == tn_ivrs)
                {
                    nSelIndex = 7;
                }
                else if (tnSel.Parent == tn_monitor_groups)
                {
                    nSelIndex = 8;
                }
                else if (tnSel.Parent == tn_conferooms)
                {
                    nSelIndex = 9;
                }
                else if (tnSel.Parent == tn_chans)
                {
                    nSelIndex = 10;
                }
                else if (tnSel.Parent == tn_pbx)
                {
                    nSelIndex = tnSel.Index;
                }
            }

            tvMainForm.Nodes.Clear();

            tn_pbx = tvMainForm.Nodes.Add("PBX");
            tn_extens = tn_pbx.Nodes.Add("Extensions");
            tn_extens.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_exten.Count; i++)
                tn_extens.Nodes.Add(pbx.sip_exten[i].UserName);

            tn_sip_accounts = tn_pbx.Nodes.Add("SIP Accounts");
            tn_sip_accounts.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                if (pbx.sip_acct[i].UserName.Length == 0)
                    tn_sip_accounts.Nodes.Add(pbx.sip_acct[i].DisplayName);
                else
                    tn_sip_accounts.Nodes.Add(pbx.sip_acct[i].UserName);
            }

            tn_dial_plans = tn_pbx.Nodes.Add("Dial Plans");
            tn_dial_plans.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                tn_dial_plans.Nodes.Add(pbx.sip_dialplan[i].planName);

            tn_acd_agents = tn_pbx.Nodes.Add("ACD Agents");
            tn_acd_agents.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                tn_acd_agents.Nodes.Add(pbx.sip_agents[i].Code);
            }

            tn_hunt_groups = tn_pbx.Nodes.Add("Hunt Groups(ACD)");
            tn_hunt_groups.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
                tn_hunt_groups.Nodes.Add(pbx.sip_huntgroups[i].hgName);

            tn_parking_slot = tn_pbx.Nodes.Add("Parking Slots");
            tn_parking_slot.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_parkingslots.Count; i++)
                tn_parking_slot.Nodes.Add(pbx.sip_parkingslots[i].psName);

            tn_ring_groups = tn_pbx.Nodes.Add("Ring Groups");
            tn_ring_groups.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
                tn_ring_groups.Nodes.Add(pbx.sip_ringgroups[i].gpName);

            tn_ivrs = tn_pbx.Nodes.Add("IVR Menus");
            tn_ivrs.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_ivrs.Count; i++)
                tn_ivrs.Nodes.Add(pbx.sip_ivrs[i].name);

            tn_monitor_groups = tn_pbx.Nodes.Add("Monitor Groups");
            tn_monitor_groups.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_monitorgroups.Count; i++)
                tn_monitor_groups.Nodes.Add(pbx.sip_monitorgroups[i].mgName);

            tn_conferooms = tn_pbx.Nodes.Add("Conference Rooms");
            tn_conferooms.ContextMenuStrip = contextMenuStrip1;
            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
                tn_conferooms.Nodes.Add(pbx.sip_conferooms[i].conf_name);

            tn_chans = tn_pbx.Nodes.Add("Channels");
            for (int i = 0; i < pbx.ChanNum; i++)
            {
                //int idx = i + 1;
                tn_chans.Nodes.Add(i.ToString());
            }

            dataGridView1.Rows.Clear();
            dataGridView1.Columns.Clear();

            if (nSelIndex != -1)
            {
                tn_pbx.Expand();

                if (!tn_pbx.Nodes[nSelIndex].IsExpanded)
                {
                    tn_pbx.Nodes[nSelIndex].Expand();
                }
                //else
                //{
                //    tn_pbx.Nodes[nSelIndex].Collapse();
                //}

                tvMainForm.SelectedNode = tn_pbx.Nodes[nSelIndex];
            }

            //lvMainForm.Items.Clear();
            //lvMainForm.Columns.Clear();
        }

        private void PBXMainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            tvMainForm.Enabled = false;

            try
            {
                //StopPBX();
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message, "Error");
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                RefreshListView();

                if (SIPPBXWinUtil.GetWinServiceStatus("SIP PBX v3") == System.ServiceProcess.ServiceControllerStatus.Stopped)
                {
                    if (serviceRunning)
                    {
                        tvMainForm.Enabled = false;
                        serviceRunning = false;

                        startPBXToolStripMenuItem.Enabled = true;
                        stopPBXToolStripMenuItem.Enabled = false;
                        restartPBXToolStripMenuItem.Enabled = false;

                        sIPAccountToolStripMenuItem.Enabled = false;
                        extensionsToolStripMenuItem.Enabled = false;
                        aCDHuntGroupsToolStripMenuItem.Enabled = false;
                        parkingSlotToolStripMenuItem.Enabled = false;
                        ringGroupsToolStripMenuItem.Enabled = false;
                        iVRMenusToolStripMenuItem.Enabled = false;
                        conferenceRoomsToolStripMenuItem.Enabled = false;
                        dialPlanToolStripMenuItem.Enabled = false;
                        monitorGroupsToolStripMenuItem.Enabled = false;
                        pickupGroupsToolStripMenuItem.Enabled = false;

                        tasksToolStripMenuItem.Enabled = false;
                        addTasksToolStripMenuItem.Enabled = false;

                        callTimeLimitRulesToolStripMenuItem.Enabled = false;
                        callBlackListToolStripMenuItem.Enabled = false;

                        toolStripBtnPlay.Enabled = true;
                        toolStripBtnStop.Enabled = false;
                    }
                }
                else if (SIPPBXWinUtil.GetWinServiceStatus("SIP PBX v3") == System.ServiceProcess.ServiceControllerStatus.Running)
                {
                    if (!serviceRunning)
                    {
                        tvMainForm.Enabled = true;
                        serviceRunning = true;

                        startPBXToolStripMenuItem.Enabled = false;
                        stopPBXToolStripMenuItem.Enabled = true;
                        restartPBXToolStripMenuItem.Enabled = true;

                        sIPAccountToolStripMenuItem.Enabled = true;
                        extensionsToolStripMenuItem.Enabled = true;
                        aCDHuntGroupsToolStripMenuItem.Enabled = true;
                        parkingSlotToolStripMenuItem.Enabled = true;
                        ringGroupsToolStripMenuItem.Enabled = true;
                        iVRMenusToolStripMenuItem.Enabled = true;
                        conferenceRoomsToolStripMenuItem.Enabled = true;
                        dialPlanToolStripMenuItem.Enabled = true;
                        monitorGroupsToolStripMenuItem.Enabled = true;
                        pickupGroupsToolStripMenuItem.Enabled = true;

                        tasksToolStripMenuItem.Enabled = true;
                        addTasksToolStripMenuItem.Enabled = true;

                        callTimeLimitRulesToolStripMenuItem.Enabled = true;
                        callBlackListToolStripMenuItem.Enabled = true;

                        toolStripBtnPlay.Enabled = false;
                        toolStripBtnStop.Enabled = true;

                        RebuildMainTreeView();

                        GetPBXVersionFromDB();
                    }
                }

                List<string> sLogList = new List<string>();

                Int64 id = SIPPBXDBUtil.LoadDBLog(sLogList, logID, logTimeSince, pbx.db_set.myConn, log);
                if (sLogList.Count > 0)
                {
                    for (int i = 0; i < sLogList.Count; i++)
                    {
                        LogoutText(sLogList[i]);
                    }
                    logID = id;
                }
            }
            catch (Exception ex)
            {
                if (log != null)
                {
                    log.LogoutText(ex.ToString());
                }
            }


        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void extensionsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ExtenEdit exten_edit_dlg = new ExtenEdit();
            exten_edit_dlg.pbx = pbx;
            exten_edit_dlg.main_form = this;
            exten_edit_dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void sIPAccountToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SIPAccEdit sip_acc_edit_dlg = new SIPAccEdit();

            sip_acc_edit_dlg.pbx = pbx;
            sip_acc_edit_dlg.main_form = this;

            sip_acc_edit_dlg.ShowDialog();

            RebuildMainTreeView();
        }

        private void tvMainForm_AfterSelect(object sender, TreeViewEventArgs e)
        {
            RefreshListView();
        }

        public void RefreshListView()
        {
            bool bRefreshColumn = false;

            TreeNode tnSel = tvMainForm.SelectedNode;

            if (tn_curSel != tnSel)
                bRefreshColumn = true;

            tn_curSel = tnSel;

            if (tnSel == null)
                return;

            if (pbx == null) return;

            /*
            if (!tnSel.IsExpanded)
            {
                tnSel.Expand();
            }
            else
            {
                tnSel.Collapse();
            }
            */

            try
            {

                if (tnSel.Parent == tn_extens)
                {
                    ShowExtensionInListView(pbx.getExtensionByName(tnSel.Text), bRefreshColumn);
                }
                else if (tnSel.Parent == tn_sip_accounts)
                {
                    ShowSIPAcctInListView(pbx.sip_acct[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_dial_plans)
                {
                    //LogoutText("Dial Plan" + tnSel.Text + " Selected.");
                    ShowDialPlanInListView(pbx.sip_dialplan[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_hunt_groups)
                {
                    ShowHuntGroupInListView(pbx.sip_huntgroups[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_chans)
                {
                    ShowChansInListView(pbx.chan_list[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_parking_slot)
                {
                    ShowParkingSlotInListView(pbx.sip_parkingslots[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_ring_groups)
                {
                    ShowRingGroupInListView(pbx.sip_ringgroups[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_ivrs)
                {
                    ShowIVRMenusInListView(pbx.sip_ivrs[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_monitor_groups)
                {
                    ShowMonitorGroupInListView(pbx.sip_monitorgroups[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_acd_agents)
                {
                    ShowACDAgentInListView(pbx.sip_agents[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_conferooms)
                {
                    ShowConferoomInListView(pbx.sip_conferooms[tnSel.Index], bRefreshColumn);
                }
                else if (tnSel.Parent == tn_pbx)
                {
                    switch (tnSel.Index)
                    {
                        case 0: //Extensions
                            ShowExtensionInListView(null, bRefreshColumn);
                            break;
                        case 1: //SIP Accounts
                            ShowSIPAcctInListView(null, bRefreshColumn);
                            break;
                        case 2: //Dial Plans
                            ShowDialPlanInListView(null, bRefreshColumn);
                            break;
                        case 3:
                            ShowACDAgentInListView(null, bRefreshColumn);
                            break;
                        case 4: //Hunt Groups(ACD)
                            ShowHuntGroupInListView(null, bRefreshColumn);
                            break;
                        case 5:
                            ShowParkingSlotInListView(null, bRefreshColumn);
                            break;
                        case 6:
                            ShowRingGroupInListView(null, bRefreshColumn);
                            break;
                        case 7:
                            ShowIVRMenusInListView(null, bRefreshColumn);
                            break;
                        case 8:
                            ShowMonitorGroupInListView(null, bRefreshColumn);
                            break;
                        case 9:
                            ShowConferoomInListView(null, bRefreshColumn);
                            break;
                        case 10: //Channels
                            ShowChansInListView(null, bRefreshColumn);
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

        }

        private void ShowConferoomInListView(SIPConferRoom rm, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                //DataGridViewButtonColumn dgBtnCol = new DataGridViewButtonColumn(); 
                //dataGridView1.Columns.Add(dgBtnCol);//Add one column dynamically
                /*
                DataGridViewImageColumn dgBtnCol = new DataGridViewImageColumn(); 
                dataGridView1.Columns.Add(dgBtnCol);//Add one column dynamically
                 *private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
                {
                }
                */
                //DatagridViewImageColumn
                //What are you using to view the image? If it is a PictureViewer object then just set the sizeMode property of the image to Zoom. Then resize the PictureViewer to whaterver size you want.

                dataGridView1.ColumnCount = 2;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Channels in";
            }

            int numRows = 0;

            if(pbx.sip_conferooms.Count>0)
            {
                if (rm != null)
                    numRows = 1;
                else
                    numRows = pbx.sip_conferooms.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;
            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_conferenceroom";
            if (rm != null)
            {
                sqlstr += " WHERE Name = '" + rm.conf_name + "'";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {
                            dataGridView1.Rows[row_idx].Cells[0].Value = myReader.GetString(0);
                            dataGridView1.Rows[row_idx].Cells[1].Value = myReader.GetString(1);
                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }

/*
            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                if (rm != null)
                {
                    if (pbx.sip_conferooms[i] != rm)
                        continue;
                }

                dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_conferooms[i].conf_name;

                string chanList = "";

                for (int j = 0; j < pbx.sip_conferooms[i].conf_chans.Count; j++)
                {
                    chanList += pbx.sip_conferooms[i].conf_chans[j].index.ToString() + ";";
                }

                dataGridView1.Rows[row_idx].Cells[1].Value = chanList;

                row_idx++;
            }
*/

        }

        public void RefreshACDAgentStatus(SIPPBXAgent agent)
        {
            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_agent";
            if (agent != null)
            {
                sqlstr += " WHERE AgentCode = '" + agent.Code + "'";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        agent = pbx.getAgentByCode(myReader.GetString(0));
                        if (agent != null)
                        {
                            if (myReader.GetString(2).Equals("Offline"))
                            {
                                agent.AtExten = null;
                            }
                            else
                            {
                                agent.AtExten = pbx.getExtensionByName(myReader.GetString(2).Substring(13).Trim());
                                agent.LogInTime = myReader.GetDateTime(3);
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }
                finally
                {
                    myReader.Close();
                }

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

        }

        private void ShowACDAgentInListView(SIPPBXAgent agent, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewImageColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewButtonColumn());

                //dataGridView1.ColumnCount = 4;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Code";
                dataGridView1.Columns[2].HeaderText = "";
                dataGridView1.Columns[3].HeaderText = "Status";
                dataGridView1.Columns[4].HeaderText = "LoginTime";
                dataGridView1.Columns[5].HeaderText = "Action";
            }

            int numRows = 0;

            if (pbx.sip_agents.Count > 0)
            {
                if (agent != null)
                    numRows = 1;
                else
                    numRows = pbx.sip_agents.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;
            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_agent";
            if (agent != null)
            {
                sqlstr += " WHERE AgentCode = '" + agent.Code + "'";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {
                            dataGridView1.Rows[row_idx].Cells[0].Value = myReader.GetString(1);
                            dataGridView1.Rows[row_idx].Cells[1].Value = myReader.GetString(0);

                            string sStatusStr = myReader.GetString(2);
                            dataGridView1.Rows[row_idx].Cells[3].Value = sStatusStr;

                            if (string.Compare(sStatusStr, "Offline") == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserOffline;
                                dataGridView1.Rows[row_idx].Cells[4].Value = "N/A";
                                dataGridView1.Rows[row_idx].Cells[5].Value = "Login";
                            }
                            else
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserIdle;
                                dataGridView1.Rows[row_idx].Cells[4].Value = myReader.GetDateTime(3).ToString("yyyy-MM-dd HH:mm:ss");
                                dataGridView1.Rows[row_idx].Cells[5].Value = "Logout";
                            }

                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }

/*
            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                if (agent != null)
                {
                    if (pbx.sip_agents[i] != agent)
                        continue;
                }

                dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_agents[i].Name;
                dataGridView1.Rows[row_idx].Cells[1].Value = pbx.sip_agents[i].Code;

                if (pbx.sip_agents[i].AtExten != null)
                {
                    dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserIdle;
                    dataGridView1.Rows[row_idx].Cells[3].Value = "Logged in at " + pbx.sip_agents[i].AtExten.UserName;
                    dataGridView1.Rows[row_idx].Cells[4].Value = pbx.sip_agents[i].LogInTime.ToString("yyyy-MM-dd HH:mm:ss");
                    dataGridView1.Rows[row_idx].Cells[5].Value = "Logout";

                }
                else
                {
                    dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserOffline;
                    dataGridView1.Rows[row_idx].Cells[3].Value = "Offline";
                    dataGridView1.Rows[row_idx].Cells[4].Value = "N/A";
                    dataGridView1.Rows[row_idx].Cells[5].Value = "Login";
                }

                row_idx++;
            }
*/

        }

        private void ShowMonitorGroupInListView(SIPPBXMonitorGroup mg, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.ColumnCount = 3;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Number";
                dataGridView1.Columns[2].HeaderText = "Extensions";
            }

            int numRows = 0;

            if (pbx.sip_monitorgroups.Count > 0)
            {
                if (pbx.sip_monitorgroups.Contains(mg))
                    numRows = 1;
                else
                    numRows = pbx.sip_monitorgroups.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;

            for (int i = 0; i < pbx.sip_monitorgroups.Count; i++)
            {
                if (mg != null)
                {
                    if (pbx.sip_monitorgroups[i] != mg)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_monitorgroups[i].mgName;
				dataGridView1.Rows[row_idx].Cells[1].Value = pbx.sip_monitorgroups[i].mgNumber;

                if (pbx.sip_monitorgroups[i].mgAllExtens)
                {
					dataGridView1.Rows[row_idx].Cells[2].Value = "All";
                }
                else
                {
                    string sExtns = "";
                    for (int j = 0; j < pbx.sip_monitorgroups[i].mgExtenList.Count; j++)
                    {
                        sExtns += pbx.sip_monitorgroups[i].mgExtenList[j] + ";";
                    }
					dataGridView1.Rows[row_idx].Cells[2].Value = sExtns;
                }

				row_idx++;

            }

        }

        private void ShowIVRMenusInListView(SIPPBXIVR ivr, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.ColumnCount = 3;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Sound File";
                dataGridView1.Columns[2].HeaderText = "DTMF Accept";
            }

            int numRows = 0;

            if (pbx.sip_ivrs.Count > 0)
            {
                if (pbx.sip_ivrs.Contains(ivr))
                    numRows = 1;
                else
                    numRows = pbx.sip_ivrs.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;

            for (int i = 0; i < pbx.sip_ivrs.Count; i++)
            {
                if (ivr != null)
                {
                    if (pbx.sip_ivrs[i] != ivr)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_ivrs[i].name;
				dataGridView1.Rows[row_idx].Cells[1].Value = pbx.sip_ivrs[i].sound_file;

                string sDTMFs = "";
                if (pbx.sip_ivrs[i].dtmfs != null)
                {
                    for (int j = 0; j < pbx.sip_ivrs[i].dtmfs.Count; j++)
                    {
                        sDTMFs += pbx.sip_ivrs[i].dtmfs[j].DTMFStr;
                        if (j != pbx.sip_ivrs[i].dtmfs.Count - 1)
                            sDTMFs += ",";
                    }
                }

				dataGridView1.Rows[row_idx].Cells[2].Value = sDTMFs;

				row_idx++;
            }


        }

        private void ShowRingGroupInListView(SIPPBXRingGroup rg, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.ColumnCount = 3;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Type";
                dataGridView1.Columns[2].HeaderText = "Destinations";
            }

            int numRows = 0;

            if (pbx.sip_ringgroups.Count > 0)
            {
                if (pbx.sip_ringgroups.Contains(rg))
                    numRows = 1;
                else
                    numRows = pbx.sip_ringgroups.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;

            for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
            {
                if (rg != null)
                {
                    if (pbx.sip_ringgroups[i] != rg)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_ringgroups[i].gpName;

                if (pbx.sip_ringgroups[i].ringType == 0)
					dataGridView1.Rows[row_idx].Cells[1].Value = "Ring All";
                else
					dataGridView1.Rows[row_idx].Cells[1].Value = "Ring by order";

                string sDest = "";
                for (int j = 0; j < pbx.sip_ringgroups[i].destList.Count; j++)
                {
                    sDest += pbx.sip_ringgroups[i].destList[j].DestAddr + ";";
                }

				dataGridView1.Rows[row_idx].Cells[2].Value = sDest;

				row_idx++;
            }

        }

        private void ShowParkingSlotInListView(SIPPBXParkingSlot ps, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.ColumnCount = 3;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Number";
                dataGridView1.Columns[2].HeaderText = "Parked Call";
            }

            int numRows = 0;

            if (pbx.sip_parkingslots.Count > 0)
            {
                if (ps != null)
                    numRows = 1;
                else
                    numRows = pbx.sip_parkingslots.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;
            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_parkingslot";
            if (ps != null)
            {
                sqlstr += " WHERE Name = '" + ps.psName + "'";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {
                            dataGridView1.Rows[row_idx].Cells[0].Value = myReader.GetString(0);
                            dataGridView1.Rows[row_idx].Cells[1].Value = myReader.GetString(1);
                            dataGridView1.Rows[row_idx].Cells[2].Value = myReader.GetString(2);

                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }

/*
            for (int i = 0; i < pbx.sip_parkingslots.Count; i++)
            {
                if (ps != null)
                {
                    if (pbx.sip_parkingslots[i] != ps)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_parkingslots[i].psName;
                dataGridView1.Rows[row_idx].Cells[1].Value = pbx.sip_parkingslots[i].psDTMF;

                if(pbx.sip_parkingslots[i].pbxChan != null)
                    dataGridView1.Rows[row_idx].Cells[2].Value = "Call on channel " + pbx.sip_parkingslots[i].pbxChan.index.ToString();
                else
                    dataGridView1.Rows[row_idx].Cells[2].Value = "";

				row_idx++;
            }
*/
        }

        private void ShowChansInListView(SIPPBXChan chan, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewImageColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewButtonColumn());
                

                //dataGridView1.ColumnCount = 5;

                dataGridView1.Columns[0].HeaderText = "Channel";
                dataGridView1.Columns[1].HeaderText = "";
                dataGridView1.Columns[2].HeaderText = "Status";
                dataGridView1.Columns[3].HeaderText = "Caller";
                dataGridView1.Columns[4].HeaderText = "Callee";
                dataGridView1.Columns[5].HeaderText = "Start Time";
                dataGridView1.Columns[6].HeaderText = "Extension";
                dataGridView1.Columns[7].HeaderText = "Action";
            }

            int numRows = 0;

            if (pbx.ChanNum > 0)
            {
                if (chan != null)
                    numRows = 1;
                else
                    numRows = pbx.ChanNum;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;
            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_channel";
            if (chan != null)
            {
                sqlstr += " WHERE ChanID = " + chan.index.ToString();
            }
            else
            {
                sqlstr += " ORDER BY ChanID ASC";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {
                            int chIndex = myReader.GetInt32(0);
                            dataGridView1.Rows[row_idx].Cells[0].Value = chIndex.ToString();
                            string sStatusStr = myReader.GetString(1);
                            dataGridView1.Rows[row_idx].Cells[2].Value = sStatusStr;
                            if (string.Compare(sStatusStr, "IDLE", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanIdle;
                                dataGridView1.Rows[row_idx].Cells[5].Value = "";
                            }
                            else if (string.Compare(sStatusStr, "DIALING", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                                dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(4).ToString("yyyy-MM-dd HH:mm:ss");
                            }
                            else if (string.Compare(sStatusStr, "OFFERED", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                                dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(4).ToString("yyyy-MM-dd HH:mm:ss");
                            }
                            else if (string.Compare(sStatusStr, "CONNECTED", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanInCall;
                                dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(4).ToString("yyyy-MM-dd HH:mm:ss");
                            }
                            else if (string.Compare(sStatusStr, "DISCONNECTING", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                                dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(4).ToString("yyyy-MM-dd HH:mm:ss");
                            }
                            else if (string.Compare(sStatusStr, "HOLDING", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanInCall;
                                dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(4).ToString("yyyy-MM-dd HH:mm:ss");
                            }
                            else if (string.Compare(sStatusStr, "BE HOLDED", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanInCall;
                                dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(4).ToString("yyyy-MM-dd HH:mm:ss");
                            }
                            else if (string.Compare(sStatusStr, "RESERVED", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                                dataGridView1.Rows[row_idx].Cells[5].Value = "";
                            }

                            dataGridView1.Rows[row_idx].Cells[3].Value = myReader.GetString(2);
                            dataGridView1.Rows[row_idx].Cells[4].Value = myReader.GetString(3);

                            dataGridView1.Rows[row_idx].Cells[6].Value = myReader.GetString(5);
                            dataGridView1.Rows[row_idx].Cells[7].Value = "Reset";

                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }


/*
            for (int i = 0; i < pbx.ChanNum; i++)
            {
                if(chan != null)
                {
                    if(pbx.chan_list[i] != chan)
                        continue;
                }

                string sExtenID = (pbx.chan_list[i].link_exten != null) ? pbx.chan_list[i].link_exten.UserName : ""; 

				dataGridView1.Rows[row_idx].Cells[0].Value = i.ToString();
                dataGridView1.Rows[row_idx].Cells[6].Value = sExtenID;

                GTAPIASM.GTAPIChan api_chan = env.GetChannel(pbx.chan_list[i].index);
                switch (api_chan.ch_status)
                {
                    case GTAPIASM.GTAPI_CHANNEL_STATE.IDLE:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanIdle;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "IDLE";
                        dataGridView1.Rows[row_idx].Cells[6].Value = "";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.DIALING:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "DIALING";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "OFFERED";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanInCall;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "CONNECTED";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.DISCONNECTING:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "DISCONNECTING";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanInCall;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "HOLDING";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanInCall;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "BE HOLDED";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.RESERVED:
                        dataGridView1.Rows[row_idx].Cells[1].Value = bmpChanFlashing;
                        dataGridView1.Rows[row_idx].Cells[2].Value = "RESERVED";
                        break;
                }

                if (api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED)
                {
					dataGridView1.Rows[row_idx].Cells[3].Value = api_chan.caller_num;
					dataGridView1.Rows[row_idx].Cells[4].Value = api_chan.callee_num;
					dataGridView1.Rows[row_idx].Cells[5].Value = api_chan.call_start_time.ToString();
                }
                else
                {
					dataGridView1.Rows[row_idx].Cells[3].Value = "";
					dataGridView1.Rows[row_idx].Cells[4].Value = "";
					dataGridView1.Rows[row_idx].Cells[5].Value = "";
                }

                dataGridView1.Rows[row_idx].Cells[7].Value = "Reset";

                row_idx++;
            }
*/

        }

        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (pbx == null) return;

            if (tn_curSel != null)
            {
                if (e.ColumnIndex == (dataGridView1.Columns.Count - 1))//check whether is it button column or not.....
                {
                    if (tn_curSel.Parent == tn_acd_agents && e.RowIndex == 0)
                    {
                        if (string.Compare(Convert.ToString(dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex].Value), "Login", true) == 0)
                        {
                            SelectExtenForm dlg = new SelectExtenForm();
                            dlg.pbx = pbx;
                            if (dlg.ShowDialog() == DialogResult.OK)
                            {
                                if (dlg.sel_ext != null)
                                {
                                    PBXOptCmdProcess.AddSrvCmd_AgentLogin(pbx.sip_agents[tn_curSel.Index], dlg.sel_ext, pbx.db_set.myConn, log);
                                }
                            }
                        }
                        else //if (string.Compare(dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex].Value, "Logout", true) == 0)
                        {
                            PBXOptCmdProcess.AddSrvCmd_AgentLogin(pbx.sip_agents[tn_curSel.Index], null, pbx.db_set.myConn, log);
                        }

                        //ShowACDAgentInListView(pbx.sip_agents[tn_curSel.Index], false);
                    }
                    else if (tn_curSel.Parent == tn_pbx && tn_curSel.Index == 3)
                    {
                        if (string.Compare(Convert.ToString(dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex].Value), "Login", true) == 0)
                        {
                            SelectExtenForm dlg = new SelectExtenForm();
                            dlg.pbx = pbx;
                            if (dlg.ShowDialog() == DialogResult.OK)
                            {
                                if (dlg.sel_ext != null)
                                {
                                    PBXOptCmdProcess.AddSrvCmd_AgentLogin(pbx.sip_agents[e.RowIndex], dlg.sel_ext, pbx.db_set.myConn, log);
                                }
                            }
                        }
                        else
                        {
                            PBXOptCmdProcess.AddSrvCmd_AgentLogin(pbx.sip_agents[e.RowIndex], null, pbx.db_set.myConn, log);
                        }

                        //ShowACDAgentInListView(null, false);
                    }
                    else if (tn_curSel.Parent == tn_chans && e.RowIndex == 0)
                    {
                        //if (env.GetChannel(tn_curSel.Index).ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                        {
                            PBXOptCmdProcess.AddSrvCmd_ResetChannel(pbx.chan_list[tn_curSel.Index], pbx.db_set.myConn, log);
                        }
                    }
                    else if (tn_curSel.Parent == tn_pbx && tn_curSel.Index == 10)
                    {
                        //if (env.GetChannel(e.RowIndex).ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                        {
                            PBXOptCmdProcess.AddSrvCmd_ResetChannel(pbx.chan_list[e.RowIndex], pbx.db_set.myConn, log);
                        }
                    }
                    else if (tn_curSel.Parent == tn_hunt_groups && e.RowIndex == 0)
                    {
                        PBXOptCmdProcess.AddSrvCmd_ResetACD(pbx.sip_huntgroups[tn_curSel.Index], pbx.db_set.myConn, log);
                    }
                    else if (tn_curSel.Parent == tn_pbx && tn_curSel.Index == 4)
                    {
                        PBXOptCmdProcess.AddSrvCmd_ResetACD(pbx.sip_huntgroups[e.RowIndex], pbx.db_set.myConn, log);
                    }
                }
            }

        }

        private void ShowHuntGroupInListView(SIPPBXACDHuntGroup hg, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewButtonColumn());

                //dataGridView1.ColumnCount = 5;
                dataGridView1.Columns[0].HeaderText = "Name";
                dataGridView1.Columns[1].HeaderText = "Type";
                dataGridView1.Columns[2].HeaderText = "Agents";
                dataGridView1.Columns[3].HeaderText = "Calls";
                dataGridView1.Columns[4].HeaderText = "WaitTime";
                dataGridView1.Columns[5].HeaderText = "Action";
            }

            int numRows = 0;

            if (pbx.sip_huntgroups.Count > 0)
            {
                if (hg != null)
                    numRows = 1;
                else
                    numRows = pbx.sip_huntgroups.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;

            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_acd";
            if (hg != null)
            {
                sqlstr += " WHERE ACD_Name = '" + hg.hgName + "'";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {
                            dataGridView1.Rows[row_idx].Cells[0].Value = myReader.GetString(0);
                            dataGridView1.Rows[row_idx].Cells[1].Value = myReader.GetString(1);
                            dataGridView1.Rows[row_idx].Cells[2].Value = myReader.GetString(2);
                            dataGridView1.Rows[row_idx].Cells[3].Value = myReader.GetString(3);
                            dataGridView1.Rows[row_idx].Cells[4].Value = myReader.GetString(4);
                            dataGridView1.Rows[row_idx].Cells[5].Value = "Reset";

                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }

/*
            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
            {
                if (hg != null)
                {
                    if (pbx.sip_huntgroups[i] != hg)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_huntgroups[i].hgName;

                switch (pbx.sip_huntgroups[i].hgType)
                {
                    case 0:
						dataGridView1.Rows[row_idx].Cells[1].Value = "Linear";
                        break;
                    case 1:
						dataGridView1.Rows[row_idx].Cells[1].Value = "Circle";
                        break;
                    case 2:
						dataGridView1.Rows[row_idx].Cells[1].Value = "Most Idle";
                        break;
                    case 3:
						dataGridView1.Rows[row_idx].Cells[1].Value = "Most Skill";
                        break;
                }

                string s = "";
                for (int j = 0; j < pbx.sip_huntgroups[i].agents.Count; j++)
                {
                    s += pbx.sip_huntgroups[i].agents[j] + ";";
                }
				dataGridView1.Rows[row_idx].Cells[2].Value = s;

                s = pbx.sip_huntgroups[i].calls.Count.ToString();
                if (pbx.sip_huntgroups[i].calls.Count > 0)
                {
                    s += "(CH:";
                    for (int j = 0; j < pbx.sip_huntgroups[i].calls.Count; j++)
                    {
                        GTOpAsync op = pbx.sip_huntgroups[i].calls[j].op;
                        if (op != null)
                        {
                            if (op.getPBXChan() != null)
                                s += op.getPBXChan().index.ToString();
                        }
                        if (j != pbx.sip_huntgroups[i].calls.Count - 1)
                        {
                            s += ",";
                        }
                    }
                    s += ")";
                }
				dataGridView1.Rows[row_idx].Cells[3].Value = s;

                s = "";
                if (pbx.sip_huntgroups[i].calls.Count > 0)
                {
                    for (int j = 0; j < pbx.sip_huntgroups[i].calls.Count; j++)
                    {
                        GTOpAsync op = pbx.sip_huntgroups[i].calls[j].op;
                        if (op != null)
                        {
                            if (op.getPBXChan() != null)
                            {
                                if (op.getPBXChan().acd_queue != null)
                                {
                                    TimeSpan sp = DateTime.Now - op.getPBXChan().in_queue_time;
                                    s += SIPPBXDBUtil.FormatTimeSpan(sp, false); //sp.ToString();
                                }
                            }
                        }
                        if (j != pbx.sip_huntgroups[i].calls.Count - 1)
                        {
                            s += " ";
                        }
                    }
                }
				dataGridView1.Rows[row_idx].Cells[4].Value = s;

                dataGridView1.Rows[row_idx].Cells[5].Value = "Reset";

                row_idx++;
            }
 */
        }

        private void ShowDialPlanInListView(SIPPBXDialPlan dp, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.ColumnCount = 3;
                dataGridView1.Columns[0].HeaderText = "Plan Name";
                dataGridView1.Columns[1].HeaderText = "Call Direction";
                dataGridView1.Columns[2].HeaderText = "Called Number";
            }

            int numRows = 0;

            if (pbx.sip_dialplan.Count > 0)
            {
                if (pbx.sip_dialplan.Contains(dp))
                    numRows = 1;
                else
                    numRows = pbx.sip_dialplan.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;

            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
            {
                if (dp != null)
                {
                    if (pbx.sip_dialplan[i] != dp)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_dialplan[i].planName;

                if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
					dataGridView1.Rows[row_idx].Cells[1].Value = "Inbound";
                else
					dataGridView1.Rows[row_idx].Cells[1].Value = "Outbound";

				dataGridView1.Rows[row_idx].Cells[2].Value = pbx.sip_dialplan[i].CalledID;

   				row_idx++;
            }
        }

        private void ShowSIPAcctInListView(SIPAccount acct, bool bRefreshColumn)
        {
            if (pbx == null) return;

            if (bRefreshColumn)
            {
                dataGridView1.Rows.Clear();
                dataGridView1.Columns.Clear();

                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewImageColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                //dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());

                //dataGridView1.ColumnCount = 4;

                dataGridView1.Columns[0].HeaderText = "Display Name";
                dataGridView1.Columns[1].HeaderText = "User Name";
                dataGridView1.Columns[2].HeaderText = "";
                dataGridView1.Columns[3].HeaderText = "Status";
                dataGridView1.Columns[4].HeaderText = "Domain";
            }

            int numRows = 0;

            if (pbx.sip_acct.Count > 0)
            {
                if (acct != null)
                    numRows = 1;
                else
                    numRows = pbx.sip_acct.Count;
            }
            else
            {
                numRows = 0;
            }

            if (numRows != dataGridView1.RowCount)
                dataGridView1.RowCount = numRows;

            int row_idx = 0;

            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_sipaccount";
            if (acct != null)
            {
                sqlstr += " WHERE UserName = '" + acct.UserName + "'";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {
                            dataGridView1.Rows[row_idx].Cells[0].Value = myReader.GetString(1);
                            dataGridView1.Rows[row_idx].Cells[1].Value = myReader.GetString(2);

                            string sStatusStr = myReader.GetString(3);
                            dataGridView1.Rows[row_idx].Cells[3].Value = sStatusStr;

                            if (string.Compare(sStatusStr, "Up", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpChanInCall;
                            }
                            else //if (string.Compare(sStatusStr, "Offline", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpChanIdle;
                            }

                            dataGridView1.Rows[row_idx].Cells[4].Value = myReader.GetString(4);

                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }

/*
            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                if (acct != null)
                {
                    if (pbx.sip_acct[i] != acct)
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_acct[i].DisplayName;
				dataGridView1.Rows[row_idx].Cells[1].Value = pbx.sip_acct[i].UserName;

                if (pbx.sip_acct[i].Registered)
                {
                    dataGridView1.Rows[row_idx].Cells[2].Value = bmpChanInCall;
					dataGridView1.Rows[row_idx].Cells[3].Value = "Up";
                }
                else
                {
                    dataGridView1.Rows[row_idx].Cells[2].Value = bmpChanIdle;
                    dataGridView1.Rows[row_idx].Cells[3].Value = "Offline";
                }

				dataGridView1.Rows[row_idx].Cells[4].Value = pbx.sip_acct[i].DomainServer;

   				row_idx++;
            }
 */

        }

        private void ShowExtensionInListView(SIPPBXExten extn, bool bRefreshColumn)
        {
            int numRows = 0;
            int row_idx = 0;

            if (pbx == null) return;

            try
            {
                if (bRefreshColumn)
                {
                    dataGridView1.Rows.Clear();
                    dataGridView1.Columns.Clear();

                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                    dataGridView1.Columns.Add(new DataGridViewImageColumn());
                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());
                    dataGridView1.Columns.Add(new DataGridViewTextBoxColumn());

                    //dataGridView1.ColumnCount = 5;

                    dataGridView1.Columns[0].HeaderText = "Exten";
                    dataGridView1.Columns[1].HeaderText = "Name";
                    dataGridView1.Columns[2].HeaderText = "";
                    dataGridView1.Columns[3].HeaderText = "Status";
                    dataGridView1.Columns[4].HeaderText = "Contact";
                    dataGridView1.Columns[5].HeaderText = "IdleFrom";
                    dataGridView1.Columns[6].HeaderText = "Channel";
                    dataGridView1.Columns[7].HeaderText = "Agent";
                }

                if (pbx.sip_exten.Count > 0)
                {
                    if (extn != null)
                        numRows = 1;
                    else
                        numRows = pbx.sip_exten.Count;
                }
                else
                {
                    numRows = 0;
                }

                if (numRows != dataGridView1.RowCount)
                    dataGridView1.RowCount = numRows;

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString() + "\r\n numRows:" + numRows.ToString());
                }
            }

            if (numRows == 0)
                return;

            SqlConnection myConn = pbx.db_set.myConn;

            if (myConn == null)
                return;

            string sqlstr = "SELECT * FROM status_exten";
            if (extn != null)
            {
                sqlstr += " WHERE ExtenID = '" + extn.UserName + "'";
            }
            else
            {
                sqlstr += " ORDER BY ExtenID ASC";
            }

            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sqlstr;
                catCMD.CommandTimeout = 3;
                SqlDataReader myReader = catCMD.ExecuteReader();

                try
                {
                    while (myReader.Read())
                    {
                        if (row_idx < numRows)
                        {

                            dataGridView1.Rows[row_idx].Cells[0].Value = myReader.GetString(0);
                            dataGridView1.Rows[row_idx].Cells[1].Value = myReader.GetString(1);
                            dataGridView1.Rows[row_idx].Cells[5].Value = myReader.GetDateTime(2).ToString("yyyy-MM-dd HH:mm:ss");
                            
                            if(myReader.GetInt32(3) == -1)
                                dataGridView1.Rows[row_idx].Cells[6].Value = "";
                            else
                                dataGridView1.Rows[row_idx].Cells[6].Value = myReader.GetInt32(3).ToString();

                            dataGridView1.Rows[row_idx].Cells[7].Value = myReader.GetString(4).ToString();

                            string sStatusStr = myReader.GetString(5);
                            dataGridView1.Rows[row_idx].Cells[3].Value = sStatusStr;
                            if (String.Compare(sStatusStr, "Up(Idle)", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserIdle;
                            }
                            else if (String.Compare(sStatusStr, "Up(Offered)", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                            }
                            else if (String.Compare(sStatusStr, "Up(Dialing)", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                            }
                            else if (String.Compare(sStatusStr, "Up(Ringing)", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                            }
                            else if (String.Compare(sStatusStr, "Up(In Call)", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                            }
                            else if (String.Compare(sStatusStr, "Offline", true) == 0)
                            {
                                dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserOffline;
                            }

                            dataGridView1.Rows[row_idx].Cells[4].Value = myReader.GetString(6);

                            row_idx++;
                        }
                        else
                            break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                    {
                        log.LogoutText(e.ToString());
                    }
                }

                myReader.Close();

            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

            if (row_idx != numRows)
            {
                dataGridView1.RowCount = row_idx;
            }

/*
            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                if (extn != null)
                {
                    if (extn != pbx.sip_exten[i])
                        continue;
                }

				dataGridView1.Rows[row_idx].Cells[0].Value = pbx.sip_exten[i].UserName;
				dataGridView1.Rows[row_idx].Cells[1].Value = pbx.sip_exten[i].RealName;

               
                if (pbx.sip_exten[i].IsRegistered())
                {
                    string sChanID = "";
                    SIPPBXChan pbxChan = pbx.getChanByExten(pbx.sip_exten[i]);
                    if(pbxChan != null)
                    {
                        sChanID = pbxChan.index.ToString();
                    }

					switch(pbx.sip_exten[i].InCalling)
					{
					case 0:
						dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserIdle;
                        dataGridView1.Rows[row_idx].Cells[3].Value = "Up(Idle)";
                        dataGridView1.Rows[row_idx].Cells[6].Value = "";
                        break;
					case 10:
						dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                        dataGridView1.Rows[row_idx].Cells[3].Value = "Up(Offered)";
                        dataGridView1.Rows[row_idx].Cells[6].Value = sChanID;
                        break;
					case 20:
						dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                        dataGridView1.Rows[row_idx].Cells[3].Value = "Up(Dialing)";
                        dataGridView1.Rows[row_idx].Cells[6].Value = sChanID;
                        break;
					case 21:
						dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                        dataGridView1.Rows[row_idx].Cells[3].Value = "Up(Ringing)";
                        dataGridView1.Rows[row_idx].Cells[6].Value = sChanID;
                        break;
					case 30:
					default:
						dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserInCall;
                        dataGridView1.Rows[row_idx].Cells[3].Value = "Up(In Call)";
                        dataGridView1.Rows[row_idx].Cells[6].Value = sChanID;
                        break;
					}

					dataGridView1.Rows[row_idx].Cells[4].Value = pbx.sip_exten[i].ContactAddr;
                }
                else
                {
					dataGridView1.Rows[row_idx].Cells[2].Value = bmpUserOffline;
                    dataGridView1.Rows[row_idx].Cells[3].Value = "Offline";
					dataGridView1.Rows[row_idx].Cells[4].Value = "";
                    dataGridView1.Rows[row_idx].Cells[6].Value = "";
                }

				dataGridView1.Rows[row_idx].Cells[5].Value = pbx.sip_exten[i].IdleStartTime.ToString("yyyy-MM-dd HH:mm:ss");

   				row_idx++;
            }
 */
        }

        private void dialPlanToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialPlanList dialplan_list_dlg = new DialPlanList();
            dialplan_list_dlg.pbx = pbx;
            dialplan_list_dlg.main_form = this;
            dialplan_list_dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PBXV2About dlg = new PBXV2About();
            dlg.pbx = pbx;
            dlg.parent_form = this;
            dlg.Show();
        }

        private void toolStripBtnPlay_Click(object sender, EventArgs e)
        {
            if (!serviceRunning)
                StartPBX();
            else
                MessageBox.Show("PBX is already running!");
        }

        private void toolStripBtnStop_Click(object sender, EventArgs e)
        {
            if (serviceRunning)
                StopPBX();
            else
                MessageBox.Show("PBX is already stopped!");
        }


        private void startPBXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StartPBX();
        }

        private void restartPBXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StopPBX();
            Thread.Sleep(4000);
            StartPBX();
        }

        private void stopPBXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StopPBX();
            Thread.Sleep(4000);
        }

        public void StartPBX()
        {
            try
            {
                SIPPBXWinUtil.StartWinService("SIP PBX v3");
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
                MessageBox.Show("Failed to start service(SIP PBX v3)! If you are using Vista or Windows 7, please restart PBX Admin Tool by 'Run as administrator'.", "Error");
                return;
            }

            tvMainForm.Enabled = true;
            serviceRunning = true;

            startPBXToolStripMenuItem.Enabled = false;
            stopPBXToolStripMenuItem.Enabled = true;
            restartPBXToolStripMenuItem.Enabled = true;

            sIPAccountToolStripMenuItem.Enabled = true;
            extensionsToolStripMenuItem.Enabled = true;
            aCDHuntGroupsToolStripMenuItem.Enabled = true;
            parkingSlotToolStripMenuItem.Enabled = true;
            ringGroupsToolStripMenuItem.Enabled = true;
            iVRMenusToolStripMenuItem.Enabled = true;
            conferenceRoomsToolStripMenuItem.Enabled = true;
            dialPlanToolStripMenuItem.Enabled = true;
            monitorGroupsToolStripMenuItem.Enabled = true;
            pickupGroupsToolStripMenuItem.Enabled = true;

            tasksToolStripMenuItem.Enabled = true;
            addTasksToolStripMenuItem.Enabled = true;

            callTimeLimitRulesToolStripMenuItem.Enabled = true;
            callBlackListToolStripMenuItem.Enabled = true;

            toolStripBtnPlay.Enabled = false;
            toolStripBtnStop.Enabled = true;

            RebuildMainTreeView();

            GetPBXVersionFromDB();
        }

        public void StopPBX()
        {
            try
            {
                SIPPBXWinUtil.StopWinService("SIP PBX v3");
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
                MessageBox.Show("Failed to start service(SIP PBX v3)! If you are using Vista or Windows 7, please restart PBX Admin Tool by 'Run as administrator'.", "Error");
                return;
            }
            
            tvMainForm.Enabled = false;
            serviceRunning = false;

            startPBXToolStripMenuItem.Enabled = true;
            stopPBXToolStripMenuItem.Enabled = false;
            restartPBXToolStripMenuItem.Enabled = false;

            sIPAccountToolStripMenuItem.Enabled = false;
            extensionsToolStripMenuItem.Enabled = false;
            aCDHuntGroupsToolStripMenuItem.Enabled = false;
            parkingSlotToolStripMenuItem.Enabled = false;
            ringGroupsToolStripMenuItem.Enabled = false;
            iVRMenusToolStripMenuItem.Enabled = false;
            conferenceRoomsToolStripMenuItem.Enabled = false;
            dialPlanToolStripMenuItem.Enabled = false;
            monitorGroupsToolStripMenuItem.Enabled = false;
            pickupGroupsToolStripMenuItem.Enabled = false;

            tasksToolStripMenuItem.Enabled = false;
            addTasksToolStripMenuItem.Enabled = false;

            callTimeLimitRulesToolStripMenuItem.Enabled = false;
            callBlackListToolStripMenuItem.Enabled = false;

            toolStripBtnPlay.Enabled = true;
            toolStripBtnStop.Enabled = false;
        }

        private void aCDHuntGroupsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ACDHuntGroupList dlg = new ACDHuntGroupList();
            dlg.pbx = pbx;
            dlg.main_form = this;
            dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void registerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!serviceRunning)
            {
                MessageBox.Show("You can only get the license information when SIP PBX v3 service is running.", "Error");
                return;
            }

            SIPPBXCFGDB.GetPBXLicOwner(null, pbx, null, pbx.db_set.myConn, PBXMainForm.log);
            RegLicForm dlg = new RegLicForm();
            dlg.parent_form = this;
            dlg.pbx = pbx;
            if(dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysRegLicKeyToDB(null, pbx, null, pbx.db_set.myConn, PBXMainForm.log);
                MessageBox.Show("You must restart the pbx to make your new license key affective!", "Info");
            }
        }

        private void parkingSlotToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ParkingSlotList dlg = new ParkingSlotList();
            dlg.pbx = pbx;
            dlg.main_form = this;
            dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void ringGroupsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            RingGroupList dlg = new RingGroupList();
            dlg.pbx = pbx;
            dlg.main_form = this;
            dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void networksToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SIPNetSet sip_net_set_dlg = new SIPNetSet();

            sip_net_set_dlg.pbx = pbx;
            sip_net_set_dlg.main_form = this;

            if (sip_net_set_dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysNetworkSettingsToDB(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        private void proxySitesToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            SIPPBXCFGDB.GetSysProxySiteSettingsFromDB(null, pbx, null, pbx.db_set.myConn, log);
            SIPProxySiteEdit sip_proxy_site_edit_dlg = new SIPProxySiteEdit();
            sip_proxy_site_edit_dlg.pbx = pbx;
            if (sip_proxy_site_edit_dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysProxySiteToDB(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        private void foldersToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            ServerFoldersForm dlg = new ServerFoldersForm();
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysServerFoldersToDB(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        private void loadBalanceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LoadBalanceConfig dlg = new LoadBalanceConfig();
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateLoadBalanceConfig(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        private void monitorGroupsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MonitorGroupList dlg = new MonitorGroupList();
            dlg.pbx = pbx;
            dlg.main_form = this;
            dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void specialNumberToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SpecialNumForm dlg = new SpecialNumForm();
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysSpecialNumberToDB(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        /*
                private void pBXCallLogToolStripMenuItem_Click(object sender, EventArgs e)
                {
                    string fn = pbx.report_dir + "pbx_cdr.txt";
                    try
                    {
                        if(File.Exists(fn))
                            System.Diagnostics.Process.Start("notepad.exe", fn);
                        else
                            MessageBox.Show("Sorry, There is no records yet.", "Warning");
                    }
                    catch(Exception)
                    {
                    }
                }

                private void extensionCallLogToolStripMenuItem_Click(object sender, EventArgs e)
                {
                    string fn = pbx.report_dir + "exten_cdr.txt";
                    try
                    {
                        if (File.Exists(fn))
                            System.Diagnostics.Process.Start("notepad.exe", fn);
                        else
                            MessageBox.Show("Sorry, There is no records yet.", "Warning");
                    }
                    catch (Exception)
                    {
                    }
                }

                private void aCDCallLogToolStripMenuItem_Click(object sender, EventArgs e)
                {
                    string fn = pbx.report_dir + "acd_cdr.txt";
                    try
                    {
                        if (File.Exists(fn))
                            System.Diagnostics.Process.Start("notepad.exe", fn);
                        else
                            MessageBox.Show("Sorry, There is no records yet.", "Warning");
                    }
                    catch (Exception)
                    {
                    }
                }
 
 
        */

        private void setupGuideToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (SelfBrand.Length > 0)
                    MessageBox.Show("Please ask your reseller for setup help.", "Help");
                else
                    System.Diagnostics.Process.Start("http://www.pcbest.net/pbx/SIP-PBX-Reference.pdf");
            }
            catch(Exception ex)
            {
                LogoutText(ex.Message);
                //env.LOG_Trace(1, ex.Message);
                //env.LOG_Trace(1, ex.ToString());
            }
        }


        private void iVRMenusToolStripMenuItem_Click(object sender, EventArgs e)
        {
            IVRMenuList dlg = new IVRMenuList();
            dlg.pbx = pbx;
            dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void databaseConnectionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Please change <Database> section of sippbxv3.xml for DB connection settings"); 
/*
            DBSetForm dlg = new DBSetForm();
            dlg.pbx = pbx;
            dlg.env = env;
            if (dlg.ShowDialog() == DialogResult.OK)
			{
                SaveDBSettingsToRegistry();

				//reset DB connection
				if(dbPBXSet != null)
				{
					dbPBXSet.DisconnectDB();
					dbPBXSet = null;
				}

				dbPBXSet = pbx.GetDBServerSet();
				if (dbPBXSet != null)
				{
				    if (!dbPBXSet.ConnectDB())
						dbPBXSet = null;
				}
			}
 */
        }

        private void tasksToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AutoDialerTaskList dlg = new AutoDialerTaskList();
            dlg.pbx = pbx;
            dlg.ShowDialog();

        }

        private void addTasksToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (pbx.db_set == null)
            {
                MessageBox.Show("Please set database connection first in menu Server/Database Connection", "Error");
                return;
            }

            AutoDialerCallAdd dlg = new AutoDialerCallAdd();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void callDetailRecordCDRToolStripMenuItem_Click(object sender, EventArgs e)
        {
            CDROptionSet dlg = new CDROptionSet();
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysCDROptionToDB(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        private void pluginsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PluginListForm dlg = new PluginListForm();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void pickupGroupsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PickupGroupList dlg = new PickupGroupList();
            dlg.pbx = pbx;
            dlg.main_form = this;
            dlg.ShowDialog();
            RebuildMainTreeView();
        }

        private void conferenceRoomsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ConferoomList dlg = new ConferoomList();
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
            }
            RebuildMainTreeView();
        }
/*
 public struct SECURITY_ATTRIBUTES
 {
 public int nLength;
 public IntPtr lpSecurityDescriptor;
 public int bInheritHandle;
 }
*/

        /*
 // most important keys, other keys -winreg.h
 const uint HKEY_CLASSES_ROOT = 0x80000000;
 const uint HKEY_CURRENT_USER = 0x80000001;
 const uint HKEY_LOCAL_MACHINE = 0x80000002;

//        [DllImport("advapi32.dll", EntryPoint = "RegSaveKey")]
//        public static extern int RegSaveKeyA(int hKey, string lpFile, SECURITY_ATTRIBUTES lpSecurityAttributes);

        [DllImport("advapi32")]
        static extern int RegOpenKey(UIntPtr hKey, string subKey, out IntPtr pRemKey);

        [DllImport("advapi32")]
        static extern int RegCloseKey(IntPtr hKey);

        [DllImport("advapi32")]
        static extern int RegSaveKey(IntPtr hKey, string fileout, IntPtr secdesc);

        [DllImport("advapi32")]
        static extern int RegRestoreKey(IntPtr hKey, string filein, uint dwFlags);
*/

        private void clearLogsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LogRichEdit.Text = "";
        }

        private void lvMainForm_Click(object sender, EventArgs e)
        {
            //MessageBox.Show(sender.ToString());
            //MessageBox.Show(e.ToString());
        }

        private void systemOptionsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PBXSystemSetForm dlg = new PBXSystemSetForm();
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                SIPPBXCFGDB.UpdateSysOptionsToDB(null, pbx, null, pbx.db_set.myConn, log);
            }
        }

        private void tvMainForm_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (e.Button == MouseButtons.Right && e.Node != null)
            {
                tvMainForm.SelectedNode = e.Node;
                //contextMenuStrip1.Show(e.Location);
            }
        }

        private void editToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (tvMainForm.SelectedNode == tn_extens)
            {
                ExtenEdit exten_edit_dlg = new ExtenEdit();
                exten_edit_dlg.pbx = pbx;
                exten_edit_dlg.main_form = this;
                exten_edit_dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_sip_accounts)
            {
                SIPAccEdit sip_acc_edit_dlg = new SIPAccEdit();

                sip_acc_edit_dlg.pbx = pbx;
                sip_acc_edit_dlg.main_form = this;

                sip_acc_edit_dlg.ShowDialog();

                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_dial_plans)
            {
                DialPlanList dialplan_list_dlg = new DialPlanList();
                dialplan_list_dlg.pbx = pbx;
                dialplan_list_dlg.main_form = this;
                dialplan_list_dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_acd_agents)
            {
                ACDAgentList dlg = new ACDAgentList();
                dlg.pbx = pbx;
                dlg.ShowDialog();
                SIPPBXDBUtil.InitAgentStatusTable(pbx, null, pbx.db_set.myConn);
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_hunt_groups)
            {
                ACDHuntGroupList dlg = new ACDHuntGroupList();
                dlg.pbx = pbx;
                dlg.main_form = this;
                dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_parking_slot)
            {
                ParkingSlotList dlg = new ParkingSlotList();
                dlg.pbx = pbx;
                dlg.main_form = this;
                dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_ring_groups)
            {
                RingGroupList dlg = new RingGroupList();
                dlg.pbx = pbx;
                dlg.main_form = this;
                dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_ivrs)
            {
                IVRMenuList dlg = new IVRMenuList();
                dlg.pbx = pbx;
                dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_monitor_groups)
            {
                MonitorGroupList dlg = new MonitorGroupList();
                dlg.pbx = pbx;
                dlg.main_form = this;
                dlg.ShowDialog();
                RebuildMainTreeView();
            }
            else if (tvMainForm.SelectedNode == tn_conferooms)
            {
                ConferoomList dlg = new ConferoomList();
                dlg.pbx = pbx;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                }
                RebuildMainTreeView();
            }
            //else if (tvMainForm.SelectedNode == tn_chans)
            //{
            //}
 
        }

        private void pBXCallsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SearchCalls dlg = new SearchCalls();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void extensionCallsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SearchExtenCalls dlg = new SearchExtenCalls();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void aCDCallsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SearchACDCalls dlg = new SearchACDCalls();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void agentLoginAndLogoutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SearchACDAgentLog dlg = new SearchACDAgentLog();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void callTimeLimitRulesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SIPPBXCFGDB.LoadCallLimitConfigFromDB(null, pbx, null, pbx.db_set.myConn, log);
            CallLimitList dlg = new CallLimitList();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void callBlackListToolStripMenuItem_Click(object sender, EventArgs e)
        {
            CallBlockList dlg = new CallBlockList();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }
    }

    public class SIPPBXGUILog : SIPPBXLog
    {
        public PBXMainForm mMainForm;
        public SIPPBXGUILog() : base()
        {
        }

        public override void LogoutText(string sLogInfo)
        {
            mMainForm.LogoutText(sLogInfo);
        }

        public override void DoLog(string sTxt)
        {
            mMainForm.LogoutText(sTxt);
        }

    }

}