using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ConferoomEdit : Form
    {
        public SIPConferRoom room;

        public ConferoomEdit()
        {
            InitializeComponent();
        }

        private void ConferoomEdit_Load(object sender, EventArgs e)
        {
            tbConfName.Text = room.conf_name;
            tbMaxCalls.Text = room.conf_max_num.ToString();
            tbJoinPrompt.Text = room.join_prompt;
            tbLeavePrompt.Text = room.leave_prompt;
            tbMOH.Text = room.moh_dir;

            //advanced
            cbDiscCall.Checked = room.disc_call;
            tbPassword.Text = room.host_pw;
            tbPasswordPrompt.Text = room.host_pw_prompt;
            cbRecord.Checked = room.conf_record;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            tbPassword.Text = tbPassword.Text.Trim();
            tbPasswordPrompt.Text = tbPasswordPrompt.Text.Trim();

            if (tbPassword.Text.Length > 0 && tbPasswordPrompt.Text.Length == 0)
            {
                MessageBox.Show("Must give a prompt for password!");
            }

            room.conf_name = tbConfName.Text;
            room.conf_max_num = Convert.ToInt32(tbMaxCalls.Text);
            room.join_prompt = tbJoinPrompt.Text;
            room.leave_prompt = tbLeavePrompt.Text;
            room.moh_dir = tbMOH.Text;

            //advanced
            room.disc_call = cbDiscCall.Checked;
            room.host_pw = tbPassword.Text;
            room.host_pw_prompt = tbPasswordPrompt.Text;
            room.conf_record = cbRecord.Checked;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnJoinBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbJoinPrompt.Text = openFileDialog1.FileName;
            }
        }

        private void btnLeaveBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbLeavePrompt.Text = openFileDialog1.FileName;
            }
        }

        private void tbPassword_TextChanged(object sender, EventArgs e)
        {
            bool recheck;

            do
            {
                recheck = false;
                for (int i = 0; i < tbPassword.Text.Length; i++)
                {
                    if (char.IsDigit(tbPassword.Text[i]) == false)
                    {
                        MessageBox.Show("Only digits are allowed!");
                        if (i == 0)
                        {
                            tbPassword.Text = tbPassword.Text.Substring(1);
                        }
                        else if (i == tbPassword.Text.Length - 1)
                        {
                            tbPassword.Text = tbPassword.Text.Substring(0, tbPassword.Text.Length - 1);
                        }
                        else
                        {
                            tbPassword.Text = tbPassword.Text.Substring(0, i) + tbPassword.Text.Substring(i+1);
                        }
                        recheck = true;
                        break;
                    }
                }
            } while (recheck);
        }

        private void btnMOH_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a music folder";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbMOH.Text = myBrowser.DirectoryPath;
            }
        }

        private void btnPasswordPrompt_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "wav files (*.wav)|*.wav|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbPasswordPrompt.Text = openFileDialog1.FileName;
            }
        }
    }
}