using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CallLimitList : Form
    {
        public SIPPBX pbx;

        public CallLimitList()
        {
            InitializeComponent();
        }

        private void CallLimitList_Load(object sender, EventArgs e)
        {
            lvCallLimitList.Columns.Clear();
            lvCallLimitList.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvCallLimitList.Columns.Add("Seconds", 80, HorizontalAlignment.Left);
            lvCallLimitList.Columns.Add("RoundupSeconds", 80, HorizontalAlignment.Left);
            cbEnable.Checked = pbx.calllimit_enabled;

            ShowCallLimitList();
        }

        public void ShowCallLimitList()
        {
            lvCallLimitList.Items.Clear();

            for (int i = 0; i < pbx.call_credits.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.call_credits[i].Name);
                aItem.SubItems.Add(pbx.call_credits[i].Seconds.ToString());
                aItem.SubItems.Add(pbx.call_credits[i].roundupSeconds.ToString());
                lvCallLimitList.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            CallLimit cl = new CallLimit();
            CallLimitEdit dlg = new CallLimitEdit();
            dlg.pbx = pbx;
            dlg.cl = cl;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (pbx.getCallLimitByName(cl.Name) == null)
                {
                    if (SIPPBXCFGDB.AddCallLimitToDB(cl, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        pbx.call_credits.Add(cl);
                        ShowCallLimitList();
                    }
                    else
                    {
                        MessageBox.Show("Cannot add call limit rule into DB.", "Error");
                    }
                }
                else
                {
                    MessageBox.Show("Already got " + cl.Name + ", please remove it first then add", "error");
                }
            }

        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvCallLimitList.SelectedIndices.Count > 0)
            {
                int idx = lvCallLimitList.SelectedIndices[0];
                CallLimitEdit dlg = new CallLimitEdit();
                dlg.pbx = pbx;
                dlg.cl = pbx.call_credits[idx];
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (!SIPPBXCFGDB.UpdateCallLimitInDB(dlg.cl, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log, 1))
                    {
                        MessageBox.Show("Cannot update the call limit rule in DB.", "Error");
                    }
                    ShowCallLimitList();
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }

        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvCallLimitList.SelectedIndices.Count > 0)
            {
                //ACDAgentEdit dlg = new ACDAgentEdit();
                if (SIPPBXCFGDB.RemoveCallLimitFromDB(pbx.call_credits[lvCallLimitList.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.call_credits.RemoveAt(lvCallLimitList.SelectedIndices[0]);
                    ShowCallLimitList();
                }
                else
                {
                    MessageBox.Show("Cannot remove the item from DB.", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (cbEnable.Checked != pbx.calllimit_enabled)
            {
                pbx.calllimit_enabled = cbEnable.Checked;
                SIPPBXCFGDB.UpdateCallLimitAndBlackListToDB(null, pbx, null, pbx.db_set.myConn, PBXMainForm.log);
            }
            Close();
        }
    }
}