using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CallBlockEdit : Form
    {
        public CallBlock cb;
        public SIPPBX pbx;
		
        public CallBlockEdit()
        {
            InitializeComponent();
        }

        private void CallBlockEdit_Load(object sender, EventArgs e)
        {
			tbCaller.Text = cb.Caller;
			tbCallee.Text = cb.Callee;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            cb.Caller = tbCaller.Text.Trim();
            cb.Callee = tbCallee.Text.Trim();

            if (cb.Caller.Length == 0 && cb.Callee.Length == 0)
            {
                MessageBox.Show("Both caller and callee are null string. Invalid!", "Error");
                return;
            }

            Close();			
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}
