using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CDROptionSet : Form
    {
        public SIPPBX pbx;

        public CDROptionSet()
        {
            InitializeComponent();
        }

        private void CDROptionSet_Load(object sender, EventArgs e)
        {
            if (pbx.cdr_option.pbx_cdr > 0)
            {
                cbPBXCDREnable.Checked = true;
                cbPBXCDRTxt.Enabled = true;
                cbPBXCDRDB.Enabled = true;
                if ((pbx.cdr_option.pbx_cdr & 0x01) == 0x01)
                {
                    cbPBXCDRTxt.Checked = true;
                }
                if ((pbx.cdr_option.pbx_cdr & 0x02) == 0x02)
                {
                    cbPBXCDRDB.Checked = true;
                }
            }
            else
            {
                cbPBXCDREnable.Checked = false;
                cbPBXCDRTxt.Enabled = false;
                cbPBXCDRDB.Enabled = false;
            }

            if (pbx.cdr_option.acd_cdr > 0)
            {
                cbACDCDREnable.Checked = true;
                cbACDCDRTxt.Enabled = true;
                cbACDCDRDB.Enabled = true;
                if ((pbx.cdr_option.acd_cdr & 0x01) == 0x01)
                {
                    cbACDCDRTxt.Checked = true;
                }
                if ((pbx.cdr_option.acd_cdr & 0x02) == 0x02)
                {
                    cbACDCDRDB.Checked = true;
                }
            }
            else
            {
                cbACDCDREnable.Checked = false;
                cbACDCDRTxt.Enabled = false;
                cbACDCDRDB.Enabled = false;
            }

            if (pbx.cdr_option.exten_cdr > 0)
            {
                cbExtenCDREnable.Checked = true;
                cbExtenCDRTxt.Enabled = true;
                cbExtenCDRDB.Enabled = true;
                if ((pbx.cdr_option.exten_cdr & 0x01) == 0x01)
                {
                    cbExtenCDRTxt.Checked = true;
                }
                if ((pbx.cdr_option.exten_cdr & 0x02) == 0x02)
                {
                    cbExtenCDRDB.Checked = true;
                }
            }
            else
            {
                cbExtenCDREnable.Checked = false;
                cbExtenCDRTxt.Enabled = false;
                cbExtenCDRDB.Enabled = false;
            }

            if (pbx.cdr_option.agent_cdr > 0)
            {
                cbAgentCDREnable.Checked = true;
                cbAgentCDRTxt.Enabled = true;
                cbAgentCDRDB.Enabled = true;
                if ((pbx.cdr_option.agent_cdr & 0x01) == 0x01)
                {
                    cbAgentCDRTxt.Checked = true;
                }
                if ((pbx.cdr_option.agent_cdr & 0x02) == 0x02)
                {
                    cbAgentCDRDB.Checked = true;
                }
            }
            else
            {
                cbAgentCDREnable.Checked = false;
                cbAgentCDRTxt.Enabled = false;
                cbAgentCDRDB.Enabled = false;
            }
        }

        private void cbPBXCDREnable_CheckedChanged(object sender, EventArgs e)
        {
            if (cbPBXCDREnable.Checked)
            {
                cbPBXCDRTxt.Enabled = true;
                cbPBXCDRDB.Enabled = true;
            }
            else
            {
                cbPBXCDRTxt.Enabled = false;
                cbPBXCDRDB.Enabled = false;
            }
        }

        private void cbACDCDREnable_CheckedChanged(object sender, EventArgs e)
        {
            if (cbACDCDREnable.Checked)
            {
                cbACDCDRTxt.Enabled = true;
                cbACDCDRDB.Enabled = true;
            }
            else
            {
                cbACDCDRTxt.Enabled = false;
                cbACDCDRDB.Enabled = false;
            }

        }

        private void cbExtenCDREnable_CheckedChanged(object sender, EventArgs e)
        {
            if (cbExtenCDREnable.Checked)
            {
                cbExtenCDRTxt.Enabled = true;
                cbExtenCDRDB.Enabled = true;
            }
            else
            {
                cbExtenCDRTxt.Enabled = false;
                cbExtenCDRDB.Enabled = false;
            }

        }

        private void cbAgentCDREnable_CheckedChanged(object sender, EventArgs e)
        {
            if (cbAgentCDREnable.Checked)
            {
                cbAgentCDRTxt.Enabled = true;
                cbAgentCDRDB.Enabled = true;
            }
            else
            {
                cbAgentCDRTxt.Enabled = false;
                cbAgentCDRDB.Enabled = false;
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            PBXCDROption cdr_opt = new PBXCDROption();

            if (cbPBXCDREnable.Checked)
            {
                if (cbPBXCDRTxt.Checked)
                    cdr_opt.pbx_cdr |= 0x01;

                if (cbPBXCDRDB.Checked)
                    cdr_opt.pbx_cdr |= 0x02;

                if (cdr_opt.pbx_cdr == 0)
                {
                    MessageBox.Show("Please choose a way to write PBX CDR", "Error");
                    return;
                }
            }

            if (cbACDCDREnable.Checked)
            {
                if (cbACDCDRTxt.Checked)
                    cdr_opt.acd_cdr |= 0x01;

                if (cbACDCDRDB.Checked)
                    cdr_opt.acd_cdr |= 0x02;

                if (cdr_opt.acd_cdr == 0)
                {
                    MessageBox.Show("Please choose a way to write ACD CDR", "Error");
                    return;
                }
            }

            if (cbExtenCDREnable.Checked)
            {
                if (cbExtenCDRTxt.Checked)
                    cdr_opt.exten_cdr |= 0x01;

                if (cbExtenCDRDB.Checked)
                    cdr_opt.exten_cdr |= 0x02;

                if (cdr_opt.exten_cdr == 0)
                {
                    MessageBox.Show("Please choose a way to write Exten CDR", "Error");
                    return;
                }
            }

            if (cbAgentCDREnable.Checked)
            {
                if (cbAgentCDRTxt.Checked)
                    cdr_opt.agent_cdr |= 0x01;

                if (cbAgentCDRDB.Checked)
                    cdr_opt.agent_cdr |= 0x02;

                if (cdr_opt.agent_cdr == 0)
                {
                    MessageBox.Show("Please choose a way to write Agent CDR", "Error");
                    return;
                }
            }

            pbx.cdr_option = cdr_opt;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}