using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class AutoDialerTaskList : Form
    {
        public SIPPBX pbx;

        public AutoDialerTaskList()
        {
            InitializeComponent();
        }

        private void AutoDialerTaskList_Load(object sender, EventArgs e)
        {
            lvTasks.Columns.Clear();
            lvTasks.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvTasks.Columns.Add("Status", 80, HorizontalAlignment.Left);
            lvTasks.Columns.Add("Type Code", 80, HorizontalAlignment.Left);
            lvTasks.Columns.Add("SIP Account", 120, HorizontalAlignment.Left);
            lvTasks.Columns.Add("Dial Plan", 120, HorizontalAlignment.Left);

            ShowTasksList();
        }

        public void ShowTasksList()
        {
            lvTasks.Items.Clear();

            for (int i = 0; i < pbx.auto_dialer_tasks.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.auto_dialer_tasks[i].task_name);
                aItem.SubItems.Add(pbx.auto_dialer_tasks[i].isOn?"Enabled":"Disabled");
                aItem.SubItems.Add(pbx.auto_dialer_tasks[i].type_code.ToString());
                aItem.SubItems.Add(pbx.auto_dialer_tasks[i].sip_acc);
                aItem.SubItems.Add(pbx.auto_dialer_tasks[i].dial_plan);
                lvTasks.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            AutoDialerTask task = new AutoDialerTask();
            AutoDialerTaskEdit dlg = new AutoDialerTaskEdit();
            dlg.pbx = pbx;
            dlg.task = task;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddAutoDialerTasksToDB(task, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.auto_dialer_tasks.Add(task);
                    ShowTasksList();
                }
                else
                {
                    MessageBox.Show("Cannot add auto dialer task into DB.", "Error");
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvTasks.SelectedIndices.Count > 0)
            {
                int idx = lvTasks.SelectedIndices[0];

                AutoDialerTaskEdit dlg = new AutoDialerTaskEdit();
                dlg.pbx = pbx;
                dlg.task = pbx.auto_dialer_tasks[idx];

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (!SIPPBXCFGDB.UpdateAutoDialerTaskInDB(dlg.task, null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                    {
                        MessageBox.Show("Cannot update the auto dialer task in DB.", "Error");
                    }
                    ShowTasksList();
                }
            }
            else
            {
                MessageBox.Show("Please select a task first!", "Error");
            }

        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvTasks.SelectedIndices.Count > 0)
            {
                //ACDAgentEdit dlg = new ACDAgentEdit();
                if (SIPPBXCFGDB.RemoveAutoDialerTaskFromDB(pbx.auto_dialer_tasks[lvTasks.SelectedIndices[0]], null, pbx, null, pbx.db_set.myConn, PBXMainForm.log))
                {
                    pbx.auto_dialer_tasks.RemoveAt(lvTasks.SelectedIndices[0]);
                    ShowTasksList();
                }
                else
                {
                    MessageBox.Show("Cannot remove the auto dialer task from DB.", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select a task first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }


    }
}