﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Reflection;
using System.ServiceProcess;

namespace PBXv3Watcher
{
    public class CSPBXv3WatcherEnv : GTAPIASM.GTAPIEnv
    {
        public uint TimerValue;
        public string CallerId;
        public string CalledId;
        public int MaxNotConnectedNum;

        public string PBXv3ServiceName;
        public int NotConnected = 0;

        public CSPBXv3WatcherEnv()
            : base()
        {
            TimerValue = 10000;
            CalledId = "";
            MaxNotConnectedNum = 1;
            PBXv3ServiceName = "SIP PBX v3";
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            if (ch == 0)
            {
                NotConnected = 0;
                Thread.Sleep(2000);
                Send_HangUp(ch, 0, "");
            }
        }

        public override void On_RecvOffered(int ch, string sCaller, string sCallee, string sDestAddr, string sViaAddr, string sFromIP, ushort nFromPort)
        {
            base.On_RecvOffered(ch, sCaller, sCallee, sDestAddr, sViaAddr, sFromIP, nFromPort);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == 0)
            {
                if (NotConnected >= MaxNotConnectedNum)
                {
                    //Restart PBXv3 service.
                    try
                    {
                        if (GetWinServiceStatus(PBXv3ServiceName) == System.ServiceProcess.ServiceControllerStatus.Running)
                        {
                            StopWinService(PBXv3ServiceName);
                        }
                    }
                    catch (Exception e)
                    {
                        LOG_Trace(4, e.ToString());
                    }

                    Thread.Sleep(60000);

                    try
                    {
                        StartWinService(PBXv3ServiceName);
                    }
                    catch (Exception e)
                    {
                        LOG_Trace(4, e.ToString());
                    }

                    NotConnected = 0;
                    StartTimer(ch, 60000);
                }
                else
                {
                    StartTimer(ch, TimerValue);
                }
            }
        }

        public override void On_RecvRinging(int ch)
        {
            base.On_RecvRinging(ch);
        }

        public override void On_RecvRegStatus(int user_id, int status, int regtime)
        {
            base.On_RecvRegStatus(user_id, status, regtime);
        }

        public override void On_RecvDTMFKeyDown(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyDown(ch, keyValue, ticks);
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);
        }

        public override void On_RecvDTMFDone(int ch, int doneReason, string dtmfBuf)
        {
            base.On_RecvDTMFDone(ch, doneReason, dtmfBuf);
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);
            LOG_Trace(4, "On_Timer chan:" + ch.ToString() + " called id:" + CalledId);
            if (ch == 0)
            {
                if (CalledId.Length > 0)
                {
                    NotConnected++;
                    Send_Make(ch, CalledId, CallerId);
                    return;
                }
            }
            StartTimer(ch, TimerValue);
        }

        public static ServiceControllerStatus GetWinServiceStatus(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            ServiceControllerStatus status = service.Status;
            service.Dispose();
            return status;
        }

        public static void StartWinService(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            service.Start();
            service.Dispose();
        }

        public static void StopWinService(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            service.Stop();
            service.Dispose();
        }

    }
}
