using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;

namespace MyPBXPluginInit
{
    public class MySIPPBXPluginClient : ISIPPBXPluginClient
    {
        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public MySIPPBXPluginClient()
        {
            m_strName = "Init Plugin Demo";
            m_strType = "Init";
        }

        public string Name
        {
            get { return m_strName; }
            set { m_strName = value; }
        }

        public string Type
        {
            get { return m_strType; }
            set { m_strType = value; }
        }

        public ISIPPBXPluginHost Host
        {
            get { return m_Host; }
            set
            {
                m_Host = value;
            }
        }

        public void Start()
        {
            //Running when PBX starts

            //You can set almost all PBX parameters here by this plugin

            //Host.PBXBase.sip_acct is for SIP Accounts
            //Host.PBXBase.sip_exten is for SIP Extensions
            //Host.PBXBase.sip_huntgroups is for ACD group
            //Host.PBXBase.sip_dialplan is the list for all dialplans
            //Host.PBXBase.sip_ivrs is the List for all ivr menus
            //Host.PBXBase.sip_parkingslots is for Parking slot settings
            //Host.PBXBase.sip_ringgroups is for Ring group settings
            //Host.PBXBase.sip_monitorgroups is for monitor group settings
            //Host.PBXBase.sip_conferooms is for conference rooms
            //Host.PBXBase.sip_agents is for agents
            //Host.PBXBase.db_set is for database settings
            //Host.PBXBase.sip_set is for SIP network settings

            //For this simple sample, we only log out some information
            string pbxInfo = "SIP Accounts: " + Host.PBXBase.sip_acct.Count.ToString() + " ";
            pbxInfo += "Dialplans: " + Host.PBXBase.sip_dialplan.Count.ToString() + " ";
            pbxInfo += "Extensions: " + Host.PBXBase.sip_exten.Count.ToString() + " ";
            Host.WriteLog(pbxInfo);

            //Init your personal objects to attach to PBX
            //There are twenty shared objects you can access and save object non-related to channel
            //Index from 0-19. for example, the last one is GetUserObj(19)
            object obj = Host.GetUserObj(0);

            //Index from 0-19. for example, the last one is SetUserObj(19, object)
            Host.SetUserObj(0, new int());

            //Init your personal CHANNEL objects to attach to PBX
            //There are also twenty shared objects associated channel
            //you use channel index and object index to access them
            //Get this channel's first object
            obj = Host.GetChanUserObj(0, 0); //get the first channel's first object

            //Set the first channel's first object
            Host.SetChanUserObj(0, 0, null);

            //Get channel 2's first object
            Host.GetChanUserObj(2, 0);

            //Set channel 2's first object
            Host.SetChanUserObj(2, 0, new int());



        }

        public void Done()
        {
            //Running when PBX stops
            Host.WriteLog("PBX Stopping");
        }

        #region ICloneable Members

        public MySIPPBXPluginClient Clone()
        {
            MySIPPBXPluginClient client = new MySIPPBXPluginClient();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion

    }


}
