using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;
//using System.Windows.Forms;

namespace ConfAssist
{
    public class Class1 : ISIPPBXPluginClient 
    {
        public const string RESULT_DISCONNECTED = "Disconnected";
        public const string RESULT_ERROR = "Error";

        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public Class1()
        {
            m_strName = "ConfAssist";
            m_strType = "IVRMenu";
        }
        
        public string Name
        {
            get{return m_strName;}
            set{m_strName=value;}
        }

        public string Type
        {
            get{return m_strType;}
            set{m_strType=value;}
        }
 
        public ISIPPBXPluginHost Host
        {
            get{return m_Host;}
            set
            {
                m_Host=value;
            }
        }

        public void Start()
        {
            //get the caller and callee number
            string caller_addr = Host.Channel.caller_num;
            string callee_addr = Host.Channel.callee_num;

            string caller_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_addr);
            string callee_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, callee_addr);

            bool ret = true;
            SIPConferRoom room = getConferenceRoomByName("MyHostConferene");
            if (room != null)
            {
                //the last parameter: 0 = drop out off conference room, 
                //1 = add into conference(speak and listen), 
                //2 = monitor conference room(only listening, not speaking)
                Host.Channel.pEnv.SetChanInConf(Convert.ToUInt32(room.conf_handle), Host.Channel.ch_index, 1);

                //or you can use other SDK functions, please refer to PCBest SIP SDK manual 3.10 Conference Functions and Events 
                //For example, if you want a channel only speak to particular channel, use 3.10.8	SetChanConfMask
                //Host.Channel.pEnv.SetChanConfMask(Host.Channel.ch_index, 0xFFFFFFFF); 
            }

            

            Host.WriteLog("Reached End!");
 
        }

        public void Done()
        {
            Host.WriteLog("Done! Disconnected the call.");

            //only if you want the call ends after running the this plugin
            //Host.HangUp();

            //otherwise you can use one of Host's To function to route the call
            //Host.ToExtension("110");
            //Host.ToIVRMenu("Another IVR Menu Name set already in PBX");
            //Host.ToMonitorGroup("Monitor Group Name");
            //Host.ToHuntGroup("ACD group name", false);
            //Host.ToRingGroup("Ring Group Name");
            //Host.ToVoiceMailBox("Extension Name");
            //Host.ToConferenceRoom("conference room name");
            //Host.ToPlugin("Another plugin's name");

            //to another outside number
            //Host.ToNumber("<sip:123@192.168.1.100>", null);
            //Host.ToNumber("<sip:6781992@callcentric.com>", null);
            //or
            //SIPAccount acct1;
            //acct1.DisplayName = "any";
            //acct1.UserName = "1234";
            //acct1.DomainServer = "sip.callwithus.com";
            //acct1.ProxyServer = "sip.callwithus.com";
            //acct1.AuthName = "1234";
            //acct1.Password = "xxxxx";
            //Host.ToNumber("655112", acct1);

            //Host.Channel.pEnv.Send_Transfer(Host.Channel.ch_index, "<sip:0116@192.168.1.177>");

        }

        public SIPConferRoom getConferenceRoomByName(string conf_name)
        {
            for (int i = 0; i < Host.PBXBase.sip_conferooms.Count; i++)
            {
                if (Host.PBXBase.sip_conferooms[i].conf_name == conf_name)
                {
                    return Host.PBXBase.sip_conferooms[i];
                }
            }

            return null;
        }

        #region ICloneable Members

        public Class1 Clone()
        {
            Class1 client = new Class1();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion

    }
}
